package com.artfess.cgpt.contract.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.IPUtils;
import com.artfess.cgpt.contract.dao.ContractCallBackDao;
import com.artfess.cgpt.contract.manager.ContractCallBackManager;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.contract.model.ContractCallBack;
import com.artfess.cgpt.foreignApi.vo.ForeignResponseVo;
import com.artfess.cgpt.order.manager.BizRegistrationOrderManager;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.model.BizRegistrationOrderDetails;
import com.artfess.cgpt.order.vo.OrderDetailsVo;
import com.artfess.cgpt.order.vo.TransVo;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.sso.manager.SsoSystemManager;
import com.artfess.cgpt.sso.model.SsoSystem;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2023/3/15 17:58
 */
@Service
public class ContractCallBackManagerImpl extends BaseManagerImpl<ContractCallBackDao, ContractCallBack> implements ContractCallBackManager {
    @Autowired
    private SsoSystemManager ssoSystemManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private BizRegistrationOrderManager registrationOrderManager;

    @Override
    public PageList<ContractCallBack> queryAllByPage(QueryFilter<ContractCallBack> queryFilter) {
        IPage<ContractCallBack> contractCallBackIPage = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(contractCallBackIPage);
    }

    @Override
    @Transactional
    @SqlParser(filter=true)
    public void signingCompleted(String contractId, String sn, String status,
                                 String type, String contact,
                                 String operatorName, String operatorMobile,
                                 String operatorNumber,String receiverNumber,
                                 String accessKey, String secretKey,
                                 Integer dataSourceType) {
        HttpServletRequest request = HttpUtil.getRequest();

        ContractCallBack contractCallBack = new ContractCallBack(contractId,sn,status,
                type,contact,operatorName,operatorMobile,operatorNumber,receiverNumber,accessKey,
                secretKey,2);

        SsoSystem ssoSystem = ssoSystemManager.getEntityByAkAndSk(accessKey, secretKey);

        if(BeanUtils.isEmpty(ssoSystem)){
            super.save(contractCallBack);
            throw new BaseException("用户不存在或授权过期，请联系管理员");
        }
        if(BeanUtils.isNotEmpty(ssoSystem.getIsIpAstrict()) && ssoSystem.getIsIpAstrict()==1){
            if(BeanUtils.isNotEmpty(ssoSystem.getIpAddress()) && ssoSystem.getIpAddress().equals(IPUtils.getIpAddr(request))){
                super.save(contractCallBack);
                throw new BaseException("用户不存在或授权过期，请联系管理员");
            }
        }

        //根据参数的第三方合同id修改合同状态
        if(status.equalsIgnoreCase("COMPLETE")){
            if(dataSourceType==1){
                //合同
                baseMapper.updateContrStatusByThreeContrId(contractId,"3");
            }else {
                //附件
                baseMapper.updateContrStatusByThreeContrId(contractId,"3");
            }

        }

        contractCallBack.setResult(1);
        super.save(contractCallBack);
    }

}
