package com.artfess.cgpt.contract.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.contract.model.BizContractMatItem;
import com.artfess.cgpt.contract.dao.BizContractMatItemDao;
import com.artfess.cgpt.contract.manager.BizContractMatItemManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 合同物料明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@Service
public class BizContractMatItemManagerImpl extends BaseManagerImpl<BizContractMatItemDao, BizContractMatItem> implements BizContractMatItemManager {


    @Resource
    BaseContext baseContext;


    @Override
    public PageList<BizContractMatItem> queryAllByPage(QueryFilter<BizContractMatItem> queryFilter) {


        if( ! ContextUtil.getCurrentUser().isAdmin()){
            String currentOrgId = ContextUtil.getCurrentOrgId();
            queryFilter.addFilter("MAT_COMPANY_ID_",currentOrgId,QueryOP.EQUAL);
        }


        IPage<BizContractMatItem> Ipage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));

        return new PageList<>(Ipage);
    }


}
