package com.artfess.cgpt.contract.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.contract.vo.ContractVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 合同表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
public interface BizContractManager extends BaseManager<BizContract> {
    /**
     * 统计立项未签订合同的数量
     * @param noticeId 立项id
     * @param vendorId 供应商id
     * @return
     */
    Integer getNoSignContrCount(String noticeId,String vendorId);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizContract> queryAllByPage(QueryFilter<BizContract> queryFilter);

    /**
     * 分页查询供应商分组
     * @param queryFilter
     * @return
     */
    PageList<BizContract> pageVendorGroup(QueryFilter<BizContract> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    String saveOrUpdateEntity(BizContract entity);

    void saveVo(ContractVo vo);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    BizContract getDetailById(String id);

    /**
     * 根据id集合删除
     * @param ids
     */
    void removeData(List<String> ids);

    /**
     * 根据id修改状态
     * @param ids
     * @param status
     */
    void updateStatusByIds(String ids,String status);


    /**
     * 浏览合同
     * @param threeContrId 第三方合同id
     * @return 网页url
     */
    String browseContract(String threeContrId);

    /**
     * 批量下载合同文件
     * @param threeContrIds 第三方合同id集合
     * @return 本地文件地址
     */
    void downBatchContract(List<Long> threeContrIds, HttpServletResponse response);

    /**
     * 生成电子合同草稿
     * 创建合同时自动生成文档
     * @param id 本地合同表id
     * @return 合同预览页面链接
     */
    String createContract(String id) throws Exception;

    /**
     * 发起电子合同签订
     * @param threeContrId 第三方合同id
     * @return
     */
    void sendContract(String threeContrId) throws Exception;

}
