package com.artfess.cgpt.contract.dao;

import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.contract.model.ContractCallBack;
import com.baomidou.mybatisplus.annotation.SqlParser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2023/3/15 17:53
 */
public interface ContractCallBackDao extends BaseMapper<ContractCallBack> {

    /**
     * 分页查询所有数据
     * @param page
     * @param ew
     * @return
     */
    IPage<ContractCallBack> queryAllByPage(IPage<ContractCallBack> page, @Param(Constants.WRAPPER) Wrapper<ContractCallBack> ew);

    @SqlParser(filter=true)
    void updateContrStatusByThreeContrId(@Param("contrId") String contrId,@Param("status") String status);

    @SqlParser(filter=true)
    void updateAccessorySignStatusByContrId(@Param("contrId") String contrId,@Param("status") String status);

    @SqlParser(filter=true)
    List<BizContract> getNoticeIdByThreeContrId(@Param("contrId") String contrId);

    @SqlParser(filter=true)
    Integer getNoSignContrCount(@Param("noticeId") String noticeId);

}
