package com.artfess.cgpt.contract.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.contract.manager.ContractCallBackManager;
import com.artfess.cgpt.contract.model.ContractCallBack;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:合同回调
 * @Author: Rong Tao
 * @Date: 2023/3/15 18:00
 */
@RestController
@RequestMapping("biz/contractCallBack/v1")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@Api(tags = "合同回调接口")
@Slf4j
public class ContractCallBackController extends BaseController<ContractCallBackManager, ContractCallBack> {
    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<ContractCallBack>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter queryFilter) {
        PageList<ContractCallBack> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult(true, "查询成功", result);

    }
}
