package com.artfess.cgpt.contract.controller;


import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.contract.vo.ContractVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.contract.model.BizContractMatItem;
import com.artfess.cgpt.contract.manager.BizContractMatItemManager;

import java.util.List;

/**
 * 合同物料明细表 前端控制器  不使用了
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@RestController
@RequestMapping("/bizContractMatItem/v1/")
public class BizContractMatItemController extends BaseController<BizContractMatItemManager, BizContractMatItem> {


    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizContractMatItem>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizContractMatItem> queryFilter){
        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);
        PageList<BizContractMatItem> result=baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }



    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "entity", value = "通用查询器") @RequestBody BizContractMatItem item) {
        String message = "操作成功";
        baseService.save(item);
        return new CommonResult<>(true, message);
    }


    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizContractMatItem> selectOne(@RequestParam String id){
        BizContractMatItem result=baseService.getById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }
}
