package com.artfess.cgpt.bidding.vo;

import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.universal.model.Accessory;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * @Description:报价VO
 * @Author: Rong Tao
 * @Date: 2024/3/28 21:04
 */
@Data
@ApiModel(value="QuoVo对象", description="报价VO")
public class QuoVo {

    @ApiModelProperty(value = "物资立项")
    private MatApproval matApproval;

    @ApiModelProperty(value = "项目立项")
    private ProjectApproval projectApproval;

//    @ApiModelProperty(value = "报价金额")
//    private BigDecimal quoPrice;

    @ApiModelProperty(value = "竞拍结束时间")
//    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime auctionEndDate;

}
