package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Description: 报价模版表
 * @Author: Rong Tao
 * @Date: 2024/3/15 18:10
 */
@ApiModel(value="QuotationTemplate对象", description="报价模版表")
@Data
@TableName("biz_quotation_template")
public class QuotationTemplate extends BizModel<QuotationTemplate> {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "编制公司ID")
    @TableField("PREPARED_ORG_ID_")
    private String preparedOrgId;

    @ApiModelProperty(value = "编制公司编码")
    @TableField("PREPARED_ORG_CODE_")
    private String preparedOrgCode;

    @ApiModelProperty(value = "编制公司名称")
    @TableField("PREPARED_ORG_NAME_")
    private String preparedOrgName;

    @ApiModelProperty(value = "编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "报价方式（1：现金，2：承兑）")
    @TableField("QUOTATION_METHOD_")
    private Integer quotationMethod;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private String isTax;

    @ApiModelProperty(value = "标的类型（1：物资，2：项目）")
    @TableField("TARGET_TYPE_")
    private Integer targetType;

    @ApiModelProperty(value = "是否默认（0：否，1：是）")
    @TableField("IS_DEFAULT_")
    private Integer isDefault;

    @ApiModelProperty(value = "是否启用（0：否，1：是）")
    @TableField("IS_ENABLE_")
    private Integer isEnable;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "报价模版明细集合")
    @TableField(exist = false)
    private List<QuotationTemplateDetail> detailList;

    @ApiModelProperty(value = "数据引用状态（0.未引用，1.已引用）")
    @TableField(exist = false)
    private Integer dataQuoteStatus;

}
