package com.artfess.cgpt.bidding.model;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @Description:定标管理明细表
 * @Author: Rong Tao
 * @Date: 2024/4/25 16:11
 */
@ApiModel(value="CalibrationDetail对象", description="定标管理明细表")
@TableName("biz_calibration_detail")
@Data
public class CalibrationDetail extends BizNoModel<CalibrationDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "定标管理ID")
    @TableField("CALIBRATION_ID_")
    private String calibrationId;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "采购立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "采购立项名称")
    @TableField("NOTICE_NAME_")
    private String noticeName;

    @ApiModelProperty(value = "采购公司ID")
    @TableField("PROCURE_ORG_ID_")
    private String procureOrgId;

    @ApiModelProperty(value = "采购公司编码")
    @TableField("PROCURE_ORG_CODE_")
    private String procureOrgCode;

    @ApiModelProperty(value = "采购公司名称")
    @TableField("PROCURE_ORG_NAME_")
    private String procureOrgName;

    @ApiModelProperty(value = "供应商ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "供应商编码")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "采购立项明细ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "物料ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "平台物料号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料分类编号")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料编码")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    private BigDecimal matNum;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "计划价格")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "执行时间")
    @TableField("EXE_TIME_")
    private LocalDateTime exeTime;

    @ApiModelProperty(value = "状态（1：未发布成交通知，2：已发布成交通知，默认1）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "中标金额")
    @TableField("WIN_BID_PRICE_")
    private BigDecimal winBidPrice;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
