package com.artfess.cgpt.bidding.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * 报价历史记录表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@ApiModel(value="BizBiddingQuotationHistory对象", description="报价历史记录表")
@TableName("biz_bidding_quotation_history")
@Data
public class BizBiddingQuotationHistory extends BizNoModel<BizBiddingQuotationHistory> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "报价轮次（关联采购立项报价轮数）")
    @TableField("QUOTATION_ROUNDS_")
    private Integer quotationRounds;

    @ApiModelProperty(value = "报价批次号(关联报价表批次号)")
    @TableField("AUCTION_BACTH_NUM_")
    private String auctionBacthNum;

    @ApiModelProperty(value = "采购立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private String noticeType;

    @ApiModelProperty(value = "报价编号（拍卖场次生成的编号）")
    @TableField("QUOTATION_NUM_")
    private Integer quotationNum;

    @ApiModelProperty(value = "采购立项明细ID，关联采购立项明细表ID")
    @TableField("NOTICE_DETAILED_ID_")
    private String noticeDetailedId;

    @ApiModelProperty(value = "报价用户联系电话")
    @TableField("QUOTATION_USER_PHONE_")
    private String quotationUserPhone;

    @ApiModelProperty(value = "报价用户ID")
    @TableField("QUOTATION_USER_ID_")
    private String quotationUserId;

    @ApiModelProperty(value = "报价用户姓名")
    @TableField("QUOTATION_USER_NAME_")
    private String quotationUserName;

    @ApiModelProperty(value = "报价用户账号")
    @TableField("QUOTATION_USER_ACCOUNT_")
    private String quotationUserAccount;

    @ApiModelProperty(value = "报价公司ID")
    @TableField("QUOTATION_COMPANY_ID_")
    private String quotationCompanyId;

    @ApiModelProperty(value = "报价公司编号")
    @TableField("QUOTATION_COMPANY_CODE_")
    private String quotationCompanyCode;

    @ApiModelProperty(value = "报价公司名称")
    @TableField("QUOTATION_COMPANY_NAME_")
    @Excel(name = "报价供应商")
    private String quotationCompanyName;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "报价时间")
    @TableField("QUOTATION_TIME_")
    private LocalDateTime quotationTime;

    @ApiModelProperty(value = "报价时间戳")
    @TableField("QUOTATION_TIMER_")
    private Long quotationTimer;

    @ApiModelProperty(value = "投标补充说明")
    @TableField("TENDER_EXPLAIN_")
    private String tenderExplain;

    @ApiModelProperty(value = "平台物料编号")
    @TableField(exist = false)
    @Excel(name = "平台物料编号")
    private String matPlatcode;
    @ApiModelProperty(value = "物料名称")
    @TableField(exist = false)
    @Excel(name = "物料名称")
    private String matName;
    @ApiModelProperty(value = "物料牌号")
    @TableField(exist = false)
    @Excel(name = "物料牌号")
    private String matMaterial;
    @ApiModelProperty(value = "规格型号")
    @TableField(exist = false)
    @Excel(name = "规格型号")
    private String matSpec;
    @ApiModelProperty(value = "计量单位")
    @TableField(exist = false)
    @Excel(name = "计量单位")
    private String matUnit;
    @ApiModelProperty(value = "结算方式（1：现金，2：承兑）")
    @TableField("QUOTATION_METHOD_")
    @Excel(name = "报价方式(1:现金,2:承兑)")
    private Integer quotationMethod;
    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    @Excel(name = "数量")
    private BigDecimal matNum;
    @ApiModelProperty(value = "报价单价")
    @TableField("QUOTATION_PRICE_")
    @Excel(name = "报价单价(元)")
    private BigDecimal quotationPrice;
    @ApiModelProperty(value = "报价总额（报价单价*数量）")
    @TableField("QUOTATION_AMOUNT_")
    @Excel(name = "报价总价(元)")
    private BigDecimal quotationAmount;
    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    @Excel(name = "税率(%)")
    private Integer taxRate;

    @ApiModelProperty(value = "物料ID")
    @TableField(exist = false)
    private String matId;
    @ApiModelProperty(value = "物料分类编号")
    @TableField(exist = false)
    private String matCategoryCode;
    @ApiModelProperty(value = "物料编码")
    @TableField(exist = false)
    private String matCode;
    @ApiModelProperty(value = "品牌")
    @TableField(exist = false)
    private String matBrand;
    @ApiModelProperty(value = "基础扩展")
    @TableField(exist = false)
    private String matBaseExt;
    @ApiModelProperty(value = "其他扩展")
    @TableField(exist = false)
    private String matOtherExt;
    @ApiModelProperty(value = "总得分")
    @TableField(exist = false)
    private BigDecimal totalScore;
    @ApiModelProperty(value = "得分排名")
    @TableField(exist = false)
    private Integer rank;
    @ApiModelProperty(value = "是否中标（0.未中标，1.已中标）")
    @TableField(exist = false)
    private Integer isSel;
    @ApiModelProperty(value = "需求日期")
    @TableField(exist = false)
    private LocalDate demandDate;
    @ApiModelProperty(value = "报价模版明细数据集合")
    @TableField(exist = false)
    private List<BiddingQuotationTemplateDetailData> quotationTemplateDetailDataList;

}
