package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.bidding.model.BizBidOpening;
import com.artfess.cgpt.bidding.dao.BizBidOpeningDao;
import com.artfess.cgpt.bidding.manager.BizBidOpeningManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import org.springframework.stereotype.Service;

/**
 * 开标记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@Service
public class BizBidOpeningManagerImpl extends BaseManagerImpl<BizBidOpeningDao, BizBidOpening> implements BizBidOpeningManager {

    @Override
    public PageList<BizBidOpening> queryAllByPage(QueryFilter<BizBidOpening> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        PageList<BizBidOpening> result = super.query(queryFilter);
        return result;
    }

}
