package com.artfess.cgpt.bidding.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.bidding.model.BizBiddingQuotationHistory;
import com.artfess.cgpt.bidding.vo.QuoVo;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.purchasing.model.MatApproval;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 当前报价表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
public interface BizBiddingQuotationManager extends BaseManager<BizBiddingQuotation> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<BizBiddingQuotation> queryAllByPage(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     * 分页查询数据（包含物资立项明细）
     * @param queryFilter
     * @return
     */
    PageList<BizBiddingQuotation> pageQuoAndMatDetail(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     * 分页查询数据（包含物资立项明细）
     * @param queryFilter
     * @return
     */
    PageList<BizBiddingQuotation> pageMatDetail(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     * 分页去重查询报价单位及评分
     * @param queryFilter
     * @return
     */
    PageList<BizBiddingQuotation> pageQuoOrg(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     * 分页查询数据（包含项目立项明细）
     * @param queryFilter
     * @return
     */
    PageList<BizBiddingQuotation> pageProDetail(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     * 分页查询数据（包含最低价标识）
     * @param queryFilter
     * @return
     */
    PageList<BizBiddingQuotation> pageLowestEva(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     /**
     * 根据明细分组获取最高报价
     * @param noticeId 立项id
     * @param round 报价轮次
     * @param type 类型
     * @return 立项明细id和最高报价的map集合
     */
    Map<String, Map<String,String>> getGroupMinPrice(String noticeId,String round,String type);

    /**
     /**
     * 根据明细分组获取最高报价
     * @param noticeId 立项id
     * @param noticeDetailId 立项明细id
     * @param round 报价轮次
     * @param type 类型
     * @return 立项明细id和最高报价的map集合
     */
    List<BizBiddingQuotation> getRankList(String noticeId,String noticeDetailId,String round,String type);

    /**
     * 物资报价
     * @param quoVo 报价vo类
     * @return 报价结果
     */
    void quoMat(QuoVo quoVo) throws Exception;

    /**
     * 项目报价
     * @param quoVo 报价vo类
     * @return 报价结果
     */
    void quoProject(QuoVo quoVo) throws Exception;

    /**
     * 开标管理-物资查询公司报价
     * @param queryFilter
     * @return
     */
    MatApproval matBidOpenOrgData(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     * 开标管理-项目查询公司报价
     * @param queryFilter
     * @return
     */
    ProjectApproval proBidOpenOrgData(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     * 评标管理-查询公司总报价
     * @param queryFilter
     * @return
     */
    PageList<BizBiddingQuotation> evaOrgQuoData(QueryFilter<BizBiddingQuotation> queryFilter);

    /**
     * 定标管理-根据公告id查询公司评分排名
     * @param noticeId 公告id
     * @return
     */
    List<BizBiddingQuotation> evaOrgRankData(String noticeId);

    /**
     * 导出数据到Excel文件
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @throws IOException IO异常
     */
    void exportDataToExcel(QueryFilter<BizBiddingQuotation> queryFilter, HttpServletResponse response) throws IOException;

}
