package com.artfess.cgpt.bidding.dao;

import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotationHistory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.ibatis.annotations.Param;

/**
 * 报价历史记录表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
public interface BizBiddingQuotationHistoryDao extends BaseMapper<BizBiddingQuotationHistory> {

    /**
     * 分页查询所有数据
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBiddingQuotationHistory> queryAllByPage(IPage<BizBiddingQuotationHistory> convert2IPage, @Param("ew") Wrapper<BizBiddingQuotationHistory> convert2Wrapper);

    /**
     * 分页查询所有数据（联查立项明细）
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<BizBiddingQuotationHistory> pageMatDetail(IPage<BizBiddingQuotationHistory> convert2IPage, @Param("ew") Wrapper<BizBiddingQuotationHistory> convert2Wrapper);

}
