package com.artfess.cgpt.bidding.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.manager.CalibrationManager;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.Calibration;
import com.artfess.cgpt.bidding.model.CalibrationDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:定标管理表
 * @Author: Rong Tao
 * @Date: 2024/4/26 10:50
 */
@Api(tags="定标管理表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
@RestController
@RequestMapping("/calibration/v1/")
public class CalibrationController extends BaseController<CalibrationManager, Calibration> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<Calibration>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<Calibration> queryFilter) {
        PageList<Calibration> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/saveByCalibra")
    @ApiOperation(value = "M-定标（综合评标法）")
    public CommonResult saveByCalibra(@RequestBody BizBiddingQuotation biddingQuotation){
        baseService.saveByCalibra(biddingQuotation);
        return new CommonResult<>(true,"操作成功");
    }

}
