package com.artfess.cgpt.bidding.controller;


import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.utils.BizUtils;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.bidding.model.BizBiddingQuotationHistory;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationHistoryManager;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 报价历史记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@RestController
@RequestMapping("/bizBiddingQuotationHistory/v1/")
public class BizBiddingQuotationHistoryController extends BaseController<BizBiddingQuotationHistoryManager, BizBiddingQuotationHistory> {

    @Autowired
    UCFeignService ucFeignService;

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizBiddingQuotationHistory>> queryByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizBiddingQuotationHistory> queryFilter) {
        BizUtils.addFilterByUserOrgAndRole(queryFilter,ucFeignService,"QUOTATION_COMPANY_ID_");
        PageList<BizBiddingQuotationHistory> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<BizBiddingQuotationHistory>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BizBiddingQuotationHistory> queryFilter) {
        PageList<BizBiddingQuotationHistory> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    /**
     * 导出数据到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportDataToExcel")
    @ApiOperation(value = "M-导出数据到Excel",notes = "参数说明：查询器只使到了query组传参，其他都可以不要")
    public CommonResult exportDataToExcel (@ApiParam(name = "queryFilter",value = "通用查询器")@RequestBody QueryFilter<BizBiddingQuotationHistory> queryFilter, HttpServletResponse response) throws IOException {
        baseService.exportDataToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

}
