package com.artfess.cgpt.bidding.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.manager.BidEvaluationRecordManager;
import com.artfess.cgpt.bidding.model.BidEvaluationDetail;
import com.artfess.cgpt.bidding.model.BidEvaluationRecord;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:评标详情表（综合评标法）
 * @Author: Rong Tao
 * @Date: 2024/7/4 20:01
 */
@RestController
@RequestMapping("/bidEvaluationRecord/v1/")
@Api(tags="评标详情表（综合评标法）")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BidEvaluationRecordController extends BaseController<BidEvaluationRecordManager, BidEvaluationRecord> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BidEvaluationRecord>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BidEvaluationRecord> queryFilter) {
        PageList<BidEvaluationRecord> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAndDetail")
    @ApiOperation(value = "M-分页查询数据（包含明细）")
    public CommonResult<PageList<BidEvaluationRecord>> pageAndDetail(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BidEvaluationRecord> queryFilter) {
        PageList<BidEvaluationRecord> result = baseService.pageAndDetail(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/bidEvaComprehensive")
    @ApiOperation(value = "M-评标-综合评标法（以供应商评标）")
    public CommonResult saveByEva(@RequestBody BidEvaluationRecord entity){
        baseService.saveByEva(entity);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/submitBidEvaluationOrg")
    @ApiOperation(value = "M-提交评标-综合评标法（以供应商评标）")
    public CommonResult submitBidEvaluationOrg(@RequestBody BidEvaluationRecord entity){
        baseService.submitBidEvaluationOrg(entity);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/bidEvaComprehensiveMat")
    @ApiOperation(value = "M-评标-综合评标法（以物料评标）")
    public CommonResult saveByEvaMat(@RequestBody BidEvaluationRecord entity){
        baseService.saveByEvaMat(entity);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/submitBidEvaluation")
    @ApiOperation(value = "M-提交评标-综合评标法（以物料评标）")
    public CommonResult submitBidEvaluation(@RequestBody BidEvaluationRecord entity){
        baseService.submitBidEvaluation(entity);
        return new CommonResult<>(true,"操作成功");
    }

}
