package com.artfess.cgpt.bidding.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.bidding.manager.BidEvaluationDetailManager;
import com.artfess.cgpt.bidding.model.BidDocuments;
import com.artfess.cgpt.bidding.model.BidEvaluationDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:评标明细记录表（综合评标法）
 * @Author: Rong Tao
 * @Date: 2024/6/30 11:18
 */
@RestController
@RequestMapping("/bidEvaluationDetail/v1/")
@Api(tags="评标明细记录表（综合评标法）")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BidEvaluationDetailController extends BaseController<BidEvaluationDetailManager, BidEvaluationDetail> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<BidEvaluationDetail>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<BidEvaluationDetail> queryFilter) {
        PageList<BidEvaluationDetail> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
