/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.ProductManager;
import com.artfess.cgpt.material.model.Product;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/product/v1/"})
@Api(tags={"\u4ea7\u54c1\u7ba1\u7406\u8868"})
@ApiGroup(group={"group_biz"})
public class ProductController
extends BaseController<ProductManager, Product> {
    @Autowired
    UCFeignService ucFeignService;

    @PostMapping(value={"/page"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<Product>> queryByPage(@RequestBody QueryFilter<Product> queryFilter) {
        String orgId = ContextUtil.getCurrentOrgId();
        if (BeanUtils.isEmpty((Object)orgId)) {
            return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)new PageList(new ArrayList()));
        }
        queryFilter.addFilter("ORG_ID_", (Object)orgId, QueryOP.EQUAL);
        PageList<Product> result = ((ProductManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/pageAll"})
    @ApiOperation(value="M-\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    public CommonResult<PageList<Product>> queryAllByPage(@RequestBody QueryFilter<Product> queryFilter) {
        PageList<Product> result = ((ProductManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/saveOrUpdateEntity"})
    @ApiOperation(value="M-\u4fdd\u5b58\u6216\u66f4\u65b0\u6570\u636e")
    public CommonResult saveOrUpdateEntity(@RequestBody Product entity) {
        ((ProductManager)this.baseService).saveOrUpdateEntity(entity);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/updateStatus"})
    @ApiOperation(value="M-\u6839\u636eid\u4fee\u6539\u72b6\u6001")
    public CommonResult updateStatus(@RequestParam(value="ids") String ids, @RequestParam(value="status") String status) {
        if (BeanUtils.isEmpty((Object)ids)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        if (BeanUtils.isEmpty((Object)status)) {
            return new CommonResult(false, "\u8bf7\u4f20\u5165\u72b6\u6001");
        }
        ((ProductManager)this.baseService).updateStatusByIds(ids, status);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)ids);
    }

    @PostMapping(value={"/removeByIds"})
    @ApiOperation(value="M-\u6839\u636eid\u6279\u91cf\u5220\u9664")
    public CommonResult remove(@RequestBody List<String> ids) {
        if (BeanUtils.isEmpty(ids) || ids.size() <= 0) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        ((ProductManager)this.baseService).removeData(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/getDataById"})
    @ApiOperation(value="M-\u6839\u636eid\u67e5\u8be2")
    public CommonResult getDataById(@RequestParam(value="id") String id) {
        if (BeanUtils.isEmpty((Object)id)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6570\u636e");
        }
        Product result = ((ProductManager)this.baseService).getDataById(id);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }
}

