/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.contract.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.contract.dao.BizContractDao;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.contract.manager.ContractItemManager;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.contract.model.ContractItem;
import com.artfess.cgpt.contract.vo.ContractVo;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.CategoryService;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.SendContractRequest;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.impl.CategoryServiceImpl;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizContractManagerImpl
extends BaseManagerImpl<BizContractDao, BizContract>
implements BizContractManager {
    private final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Value(value="${contractSys.serverUrl}")
    private String serverUrl;
    @Value(value="${contractSys.accessKey}")
    private String accessKey;
    @Value(value="${contractSys.accessSecret}")
    private String accessSecret;
    @Value(value="${contractSys.streamId}")
    private Long streamId;
    @Value(value="${contractSys.taxStreamId}")
    private Long taxStreamId;
    private CategoryService categoryService;
    private ContractService contractService;
    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private ContractItemManager contractItemManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private BizWinBiddingNoticeDetaileManager winBidNoticeDetailManager;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private SysDictionaryManager sysDictionaryManager;

    @Override
    public Integer getNoSignContrCount(String noticeId, String vendorId) {
        Integer count = ((BizContractDao)this.baseMapper).getNoSignContrCount(noticeId, vendorId);
        return count;
    }

    @Override
    public PageList<BizContract> queryAllByPage(QueryFilter<BizContract> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<BizContract> result = ((BizContractDao)this.baseMapper).queryAllByPage((IPage<BizContract>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizContract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BizContract> pageVendorGroup(QueryFilter<BizContract> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)0, QueryOP.EQUAL);
        IPage<BizContract> result = ((BizContractDao)this.baseMapper).pageVendorGroup((IPage<BizContract>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizContract>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public String saveOrUpdateEntity(BizContract entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        List<ContractItem> itemList = entity.getItemList();
        if (BeanUtils.isEmpty((Object)entity.getContrCode())) {
            entity.setContrCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "htgl_htbh"));
        }
        if (BeanUtils.isEmpty((Object)entity.getVendorTaxNumber())) {
            Enterprise vendorEnterprise = this.enterpriseManager.getByOrgIdOrCode(entity.getVendorId(), entity.getVendorCode());
            if (BeanUtils.isEmpty((Object)((Object)vendorEnterprise))) {
                throw new BaseException("\u8bf7\u5148\u524d\u5f80\u4e3b\u6570\u636e\u63a8\u9001\u4f01\u4e1a\u3010" + entity.getVendorName() + "\u3011\u4fe1\u606f");
            }
            if (BeanUtils.isEmpty((Object)vendorEnterprise.getCompanyOrgcode())) {
                throw new BaseException("\u8bf7\u5148\u524d\u5f80\u4e3b\u6570\u636e\u7ef4\u62a4\u4f01\u4e1a\u3010" + entity.getVendorName() + "\u3011\u7a0e\u53f7\uff0c\u5e76\u63a8\u9001\u5230\u91c7\u8d2d\u5e73\u53f0");
            }
            entity.setVendorTaxNumber(vendorEnterprise.getCompanyOrgcode());
        }
        if (BeanUtils.isEmpty((Object)entity.getGenerType())) {
            entity.setGenerType(1);
        }
        if (BeanUtils.isNotEmpty((Object)entity.getId())) {
            List collect;
            List detailHisList;
            LambdaQueryWrapper contractItemQW = new LambdaQueryWrapper();
            contractItemQW.eq(ContractItem::getContractId, (Object)entity.getId());
            if (entity.getGenerType() == 1 && BeanUtils.isNotEmpty((Object)(detailHisList = this.contractItemManager.list((Wrapper)contractItemQW))) && detailHisList.size() > 0 && BeanUtils.isNotEmpty(collect = detailHisList.stream().filter(s -> BeanUtils.isNotEmpty((Object)s.getWinNoticeDetailId())).map(s -> s.getWinNoticeDetailId()).collect(Collectors.toList())) && collect.size() > 0) {
                LambdaUpdateWrapper winDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)winDetailUW.set(BizWinBiddingNoticeDetaile::getContractGenerateStatus, (Object)1)).in(BizWinBiddingNoticeDetaile::getId, collect);
                this.winBidNoticeDetailManager.update((Wrapper)winDetailUW);
            }
            this.contractItemManager.remove((Wrapper)contractItemQW);
            this.accessoryService.removeBySourceId(entity.getId());
            if (entity.getIsAgencyProcure() == 1 && entity.getGenerType() == 1) {
                LambdaQueryWrapper agenyContrQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)agenyContrQW.eq(BizContract::getAgencyContrctId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
                List agenyContrHisList = super.list((Wrapper)agenyContrQW);
                if (BeanUtils.isNotEmpty((Object)agenyContrHisList) && agenyContrHisList.size() > 0) {
                    List<String> collect2 = agenyContrHisList.stream().map(s -> s.getId()).collect(Collectors.toList());
                    this.accessoryService.removeBySourceIds(collect2);
                    LambdaQueryWrapper agenyItemQW = new LambdaQueryWrapper();
                    agenyItemQW.in(ContractItem::getContractId, collect2);
                    this.contractItemManager.remove((Wrapper)agenyItemQW);
                    super.remove((Wrapper)agenyContrQW);
                }
            }
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.forEach(s -> s.setSourceId(entity.getId()));
            this.accessoryService.saveBatch(accessoryList);
        }
        if (BeanUtils.isNotEmpty(itemList) && itemList.size() > 0) {
            List winDetailIds;
            itemList.forEach(s -> s.setContractId(entity.getId()));
            if (entity.getGenerType() == 1 && BeanUtils.isNotEmpty(winDetailIds = itemList.stream().filter(s -> BeanUtils.isNotEmpty((Object)s.getWinNoticeDetailId())).map(s -> s.getWinNoticeDetailId()).collect(Collectors.toList())) && winDetailIds.size() > 0) {
                LambdaUpdateWrapper winDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)winDetailUW.set(BizWinBiddingNoticeDetaile::getContractGenerateStatus, (Object)2)).in(BizWinBiddingNoticeDetaile::getId, winDetailIds);
                this.winBidNoticeDetailManager.update((Wrapper)winDetailUW);
            }
            this.contractItemManager.saveBatch(itemList);
        }
        if (entity.getIsAgencyProcure() == 1 && entity.getGenerType() == 1) {
            this.generAgencyProcureContr(entity);
        }
        if (entity.getStatus() == 4) {
            try {
                this.createContract(entity.getId());
            }
            catch (Exception e) {
                System.out.println("\u521b\u5efa\u7535\u5b50\u5408\u540c\u8349\u7a3f\u5931\u8d25\uff1a" + e.getMessage());
                throw new BaseException("\u521b\u5efa\u7535\u5b50\u5408\u540c\u8349\u7a3f\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return entity.getId();
    }

    @Transactional
    public void generAgencyProcureContr(BizContract source) {
        List<ContractItem> itemList = source.getItemList();
        if (BeanUtils.isEmpty(itemList) || itemList.size() <= 0) {
            return;
        }
        List purAppIds = itemList.stream().filter(s -> BeanUtils.isNotEmpty((Object)s.getPurchasingApplicationId())).map(s -> s.getPurchasingApplicationId()).collect(Collectors.toList());
        if (BeanUtils.isEmpty(purAppIds) || purAppIds.size() <= 0) {
            throw new BaseException("\u672a\u627e\u5230\u4ee3\u91c7\u7533\u8bf7\u5355");
        }
        LambdaQueryWrapper purAppQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)purAppQW.eq(PurchasingApplication::getIsAgencyProcure, (Object)1)).in(PurchasingApplication::getId, purAppIds)).eq(BizModel::getIsDele, (Object)"0");
        List purchasingApplications = this.purchasingApplicationManager.list((Wrapper)purAppQW);
        if (BeanUtils.isEmpty((Object)purchasingApplications) || purchasingApplications.size() <= 0) {
            throw new BaseException("\u672a\u627e\u5230\u4ee3\u91c7\u7533\u8bf7\u5355");
        }
        Map<String, List<PurchasingApplication>> collect = purchasingApplications.stream().collect(Collectors.groupingBy(PurchasingApplication::getPreparedOrgId));
        collect.forEach((preOrgId, appList) -> {
            List collect1 = appList.stream().map(s -> s.getId()).collect(Collectors.toList());
            PurchasingApplication tempData = (PurchasingApplication)((Object)((Object)appList.get(0)));
            BizContract agencyContr = new BizContract();
            try {
                BeanUtils.copyNotNullProperties((Object)((Object)agencyContr), (Object)((Object)source));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
                throw new BaseException("\u4ee3\u91c7\u5408\u540c\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
            }
            agencyContr.setId(null);
            agencyContr.setContrCode(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "htgl_htbh"));
            agencyContr.setContrName(source.getContrName() + "-" + tempData.getPreparedOrgName() + "\u4ee3\u91c7");
            agencyContr.setMatCompanyId((String)preOrgId);
            agencyContr.setMatCompanyCode(tempData.getPreparedOrgCode());
            agencyContr.setMatCompanyName(tempData.getPreparedOrgName());
            agencyContr.setMatCompanyUserId(tempData.getPreparedUserId());
            agencyContr.setMatCompanyUserName(tempData.getPreparedUserName());
            User byId = (User)this.userManager.getById((Serializable)((Object)tempData.getPreparedUserId()));
            agencyContr.setMatCompanyUserPhone(byId.getMobile());
            agencyContr.setVendorId(source.getMatCompanyId());
            agencyContr.setVendorCode(source.getMatCompanyCode());
            agencyContr.setVendorName(source.getMatCompanyName());
            Enterprise vendorEnterprise = this.enterpriseManager.getByOrgIdOrCode(source.getMatCompanyId(), source.getMatCompanyCode());
            if (BeanUtils.isEmpty((Object)((Object)vendorEnterprise))) {
                throw new BaseException("\u8bf7\u5148\u524d\u5f80\u4e3b\u6570\u636e\u63a8\u9001\u4f01\u4e1a\u3010" + source.getMatCompanyName() + "\u3011\u4fe1\u606f");
            }
            if (BeanUtils.isEmpty((Object)vendorEnterprise.getCompanyOrgcode())) {
                throw new BaseException("\u8bf7\u5148\u524d\u5f80\u4e3b\u6570\u636e\u7ef4\u62a4\u4f01\u4e1a\u3010" + source.getMatCompanyName() + "\u3011\u7a0e\u53f7\uff0c\u5e76\u63a8\u9001\u5230\u91c7\u8d2d\u5e73\u53f0");
            }
            agencyContr.setVendorTaxNumber(vendorEnterprise.getCompanyOrgcode());
            agencyContr.setVendorUserId(source.getMatCompanyUserId());
            agencyContr.setVendorUserName(source.getMatCompanyUserName());
            agencyContr.setVendorUserPhone(source.getMatCompanyUserPhone());
            agencyContr.setGenerType(2);
            agencyContr.setIsAgencyProcure(1);
            agencyContr.setAgencyContrctId(source.getId());
            super.save((Object)agencyContr);
            List tempItems = itemList.stream().filter(s -> collect1.contains(s.getPurchasingApplicationId())).collect(Collectors.toList());
            ArrayList<ContractItem> agencyContrDetailList = new ArrayList<ContractItem>();
            for (ContractItem sourceItem : tempItems) {
                ContractItem item = new ContractItem();
                try {
                    BeanUtils.copyNotNullProperties((Object)((Object)item), (Object)((Object)sourceItem));
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                    throw new BaseException("\u4ee3\u91c7\u5408\u540c\u660e\u7ec6\u8f6c\u6362\u5931\u8d25\uff1a" + e.getMessage());
                }
                item.setId(null);
                item.setContractId(agencyContr.getId());
                agencyContrDetailList.add(item);
            }
            this.contractItemManager.saveBatch(agencyContrDetailList);
        });
    }

    @Override
    public void saveVo(ContractVo vo) {
        BizContract contract = vo.getBizContract();
        this.saveOrUpdate((Object)contract);
        List<ContractItem> items = vo.getContractItems();
        this.contractItemManager.deleByContractId(contract.getId());
        for (ContractItem item : items) {
            item.setContractId(contract.getId());
        }
        this.contractItemManager.saveOrUpdateBatch(items);
    }

    @Override
    public BizContract getDetailById(String id) {
        BizContract result = (BizContract)((Object)this.getById((Serializable)((Object)id)));
        result.setAccessoryList(this.accessoryService.getAccessoryBySourceId(id));
        result.setItemList(this.contractItemManager.getByContractId(id));
        return result;
    }

    @Override
    @Transactional
    public void removeData(List<String> ids) {
        LambdaQueryWrapper contrQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)contrQW.notIn(BizContract::getStatus, Arrays.asList("1,6".split(",")))).eq(BizModel::getIsDele, (Object)"0")).in(BizContract::getId, ids);
        if (super.count((Wrapper)contrQW) > 0) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff1a\u4ec5\u8349\u7a3f\u72b6\u6001\u53ef\u5220\u9664");
        }
        LambdaQueryWrapper contractItemQW = new LambdaQueryWrapper();
        contractItemQW.in(ContractItem::getContractId, ids);
        List detailHisList = this.contractItemManager.list((Wrapper)contractItemQW);
        if (BeanUtils.isNotEmpty((Object)detailHisList) && detailHisList.size() > 0) {
            List collect = detailHisList.stream().filter(s -> BeanUtils.isNotEmpty((Object)s.getWinNoticeDetailId())).map(s -> s.getWinNoticeDetailId()).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(collect) && collect.size() > 0) {
                LambdaUpdateWrapper winDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)winDetailUW.set(BizWinBiddingNoticeDetaile::getContractGenerateStatus, (Object)1)).in(BizWinBiddingNoticeDetaile::getId, collect);
                this.winBidNoticeDetailManager.update((Wrapper)winDetailUW);
            }
            this.contractItemManager.remove((Wrapper)contractItemQW);
        }
        LambdaQueryWrapper agenyContrQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)agenyContrQW.in(BizContract::getAgencyContrctId, ids)).eq(BizModel::getIsDele, (Object)"0");
        List agenyContrHisList = super.list((Wrapper)agenyContrQW);
        if (BeanUtils.isNotEmpty((Object)agenyContrHisList) && agenyContrHisList.size() > 0) {
            List collect = agenyContrHisList.stream().map(s -> s.getId()).collect(Collectors.toList());
            LambdaQueryWrapper agenyItemQW = new LambdaQueryWrapper();
            agenyItemQW.in(ContractItem::getContractId, collect);
            this.contractItemManager.remove((Wrapper)agenyItemQW);
            super.remove((Wrapper)agenyContrQW);
        }
        super.removeByIds(ids);
        this.accessoryService.removeBySourceIds(ids);
    }

    @Override
    @Transactional
    public void updateStatusByIds(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        if (status.equals("4")) {
            for (String id : idList) {
                try {
                    this.createContract(id);
                }
                catch (Exception e) {
                    System.out.println("\u521b\u5efa\u7535\u5b50\u5408\u540c\u8349\u7a3f\u5931\u8d25\uff1a" + e.getMessage());
                    throw new BaseException("\u521b\u5efa\u7535\u5b50\u5408\u540c\u8349\u7a3f\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        if (status.equals("5")) {
            for (String id : idList) {
                BizContract contr = (BizContract)((Object)super.getById((Serializable)((Object)id)));
                try {
                    this.sendContract(contr.getThreeContractId());
                }
                catch (Exception e) {
                    System.out.println("\u53d1\u8d77\u5408\u540c\u7b7e\u7f72\u5931\u8d25\uff1a" + e.getMessage());
                    throw new BaseException("\u53d1\u8d77\u5408\u540c\u7b7e\u7f72\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
            status = "2";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(BizContract::getStatus, (Object)status)).in(BizContract::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)updateWrapper);
    }

    public void init() {
        SDKClient sdkClient = new SDKClient(this.serverUrl, this.accessKey, this.accessSecret);
        this.contractService = new ContractServiceImpl(sdkClient);
        this.categoryService = new CategoryServiceImpl(sdkClient);
    }

    @Override
    public String browseContract(String threeContrId) {
        this.init();
        ViewUrlRequest request = new ViewUrlRequest();
        request.setContractId(Long.valueOf(threeContrId));
        request.setPageType(ViewUrlRequest.PageType.CONTENT);
        String viewUrl = null;
        try {
            viewUrl = this.contractService.viewUrl(request);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
        }
        System.out.println("\u5408\u540c\u67e5\u770b\u94fe\u63a5:" + viewUrl);
        return viewUrl;
    }

    @Override
    public void downBatchContract(List<Long> threeContrIds, HttpServletResponse response) {
        this.init();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ServletOutputStream os = response.getOutputStream();){
            String fileName = URLEncoder.encode("\u5408\u540c\u6587\u4ef6.zip", "UTF-8");
            response.setContentType("APPLICATION/OCTET-STREAM");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("filename", fileName);
            this.contractService.batchDownload(threeContrIds, (OutputStream)baos);
            response.setHeader("Content-Length", String.valueOf(baos.size()));
            os.write(baos.toByteArray());
            os.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createContract(String id) throws Exception {
        BizContract localContract = (BizContract)((Object)super.getById((Serializable)((Object)id)));
        this.init();
        Long contrStreamId = this.taxStreamId;
        ArrayList<Long> documentIdList = new ArrayList<Long>();
        List<Accessory> accessory = this.accessoryService.getAccessoryBySourceId(id);
        if (BeanUtils.isNotEmpty(accessory) && accessory.size() > 0) {
            for (Accessory a : accessory) {
                String url = a.getUrl();
                File file = null;
                InputStream inStream = null;
                OutputStream os = null;
                try {
                    file = File.createTempFile("net_url", a.getSuffix());
                    URL urlfile = new URL(url);
                    inStream = urlfile.openStream();
                    os = new FileOutputStream(file);
                    int bytesRead = 0;
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = inStream.read(buffer, 0, 8192)) != -1) {
                        os.write(buffer, 0, bytesRead);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (null != os) {
                            os.close();
                        }
                        if (null != inStream) {
                            inStream.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                CreateDocumentRequest request = new CreateDocumentRequest();
                request.setFile((FileItem)new StreamFile((InputStream)new FileInputStream(file)));
                request.setFileType(a.getSuffix());
                request.setTitle(BeanUtils.isNotEmpty((Object)a.getName()) ? a.getName() : "\u5176\u4ed6\u6587\u6863");
                CreateDocumentResult result = this.contractService.createByFile(request);
                Long documentId = result.getDocumentId();
                documentIdList.add(documentId);
            }
        }
        if (localContract.getIsTax() == 2) {
            contrStreamId = this.streamId;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("contrCode", localContract.getContrCode());
        params.put("vendor", localContract.getVendorName());
        params.put("vendorSign", localContract.getVendorName());
        params.put("matCompany", localContract.getMatCompanyName());
        params.put("matCompanySign", localContract.getMatCompanyName());
        params.put("signDate", this.DATE_FORMATTER.format(LocalDate.now()));
        params.put("startDate", this.DATE_FORMATTER.format(localContract.getContractStartDate()));
        params.put("endDate", this.DATE_FORMATTER.format(localContract.getContractEndDate()));
        params.put("matCompanyUser", localContract.getMatCompanyClientName());
        params.put("vendorUser", localContract.getVendorUserName());
        List<ContractItem> itemList = this.contractItemManager.getByContractId(id);
        ArrayList<String> tableList = new ArrayList<String>();
        if (BeanUtils.isNotEmpty(itemList) && itemList.size() > 0) {
            List payMethodDic = this.sysDictionaryManager.queryDictListItemsByCode("cglx-fkfs");
            for (ContractItem it : itemList) {
                BigDecimal price = it.getTaxInprice();
                BigDecimal amount = it.getTaxInvalue();
                String accountPeriod = "";
                if (localContract.getIsTax() == 2) {
                    price = it.getContrPrice();
                    amount = it.getContrAmount();
                }
                if (localContract.getPayMethod() == 1) {
                    if (BeanUtils.isNotEmpty((Object)it.getPendingTime())) {
                        accountPeriod = it.getPendingTime().toString();
                    }
                } else if (localContract.getPayMethod() == 2 && BeanUtils.isNotEmpty((Object)it.getAcceptanceTime())) {
                    accountPeriod = it.getAcceptanceTime().toString();
                }
                tableList.add("{\"c1\":\"" + it.getMatPlatcode() + "\",\"c2\":\"" + it.getMatName() + "\",\"c3\":\"" + (BeanUtils.isNotEmpty((Object)it.getMatSpec()) ? it.getMatSpec() : "") + "\",\"c4\":\"" + (BeanUtils.isNotEmpty((Object)it.getMatMaterial()) ? it.getMatMaterial() : "") + "\",\"c5\":\"" + it.getNum() + "\",\"c6\":\"" + it.getMatUnit() + "\",\"c7\":\"" + price + "\",\"c8\":\"" + amount + "\",\"c9\":\"" + BizUtils.getDicCodeByValue(payMethodDic, localContract.getPayMethod().toString()) + "\",\"c10\":\"" + accountPeriod + "\",\"c11\":\"" + it.getTaxRate() + "\",\"c12\":\"" + it.getTaxValue() + "\",\"c13\":\"" + (BeanUtils.isNotEmpty((Object)it.getPurNote()) ? it.getPurNote() : "") + "\",\"c14\":\"" + (BeanUtils.isNotEmpty((Object)it.getVendorNote()) ? it.getVendorNote() : "") + "\"}");
            }
            String tableParams = ((Object)tableList).toString();
            params.put("detailList", tableParams);
            System.out.println(LocalDateTime.now() + "----\u7b7e\u7f72\u5408\u540c\u660e\u7ec6\u5217\u8868\u53c2\u6570----" + tableParams);
            this.log.debug("----\u7b7e\u7f72\u5408\u540c\u660e\u7ec6\u5217\u8868\u53c2\u6570----" + tableParams);
        }
        CreateContractRequest createContractRequest = new CreateContractRequest();
        createContractRequest.setEndTime(this.DATE_FORMATTER.format(localContract.getContractEndDate()));
        createContractRequest.setSend(Boolean.valueOf(false));
        createContractRequest.setMustSign(Boolean.valueOf(true));
        createContractRequest.setExtraSign(Boolean.valueOf(true));
        createContractRequest.setAutoCreateCounterSign(Boolean.valueOf(true));
        createContractRequest.setSignAll("RECEIVER");
        createContractRequest.setMsgCode(Integer.valueOf(0));
        if (documentIdList.size() > 0) {
            createContractRequest.setDocuments(documentIdList);
        }
        createContractRequest.setSubject(localContract.getContrName());
        createContractRequest.setTenantName(localContract.getMatCompanyName());
        ArrayList<Signatory> signatories = new ArrayList<Signatory>();
        Signatory signatory1 = new Signatory();
        signatory1.setContact(localContract.getVendorUserPhone());
        signatory1.setTenantType(TenantType.COMPANY);
        signatory1.setTenantName(localContract.getVendorName());
        signatory1.setSerialNo(Integer.valueOf(2));
        signatory1.setReceiverName(localContract.getVendorUserName());
        Signatory signatory2 = new Signatory();
        signatory2.setContact(localContract.getMatCompanyUserPhone());
        signatory2.setTenantType(TenantType.COMPANY);
        signatory2.setTenantName(localContract.getMatCompanyName());
        signatory2.setSerialNo(Integer.valueOf(1));
        signatory2.setReceiverName(localContract.getMatCompanyUserName());
        signatories.add(signatory1);
        signatories.add(signatory2);
        createContractRequest.setSignatories(signatories);
        createContractRequest.setCategoryId(contrStreamId);
        createContractRequest.setDocumentParams(params);
        Long contractId = null;
        try {
            contractId = this.contractService.createContractByCategory(createContractRequest);
        }
        catch (PrivateAppException e) {
            e.printStackTrace();
        }
        System.out.println("\u521b\u5efa\u5408\u540c\u6210\u529f,contractId:" + contractId);
        localContract.setThreeContractId(contractId.toString());
        super.updateById((Object)localContract);
        return "";
    }

    @Override
    public void sendContract(String threeContrId) throws Exception {
        this.init();
        SendContractRequest request = new SendContractRequest();
        request.setContractId(Long.valueOf(threeContrId));
        this.contractService.send(request);
    }
}

