/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.dao.BidEvaluationRecordDao;
import com.artfess.cgpt.bidding.manager.BidEvaluationDetailManager;
import com.artfess.cgpt.bidding.manager.BidEvaluationRecordManager;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.model.BidEvaluationDetail;
import com.artfess.cgpt.bidding.model.BidEvaluationRecord;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import com.artfess.cgpt.project.manager.ProjectApprovalManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BidEvaluationRecordManagerImpl
extends BaseManagerImpl<BidEvaluationRecordDao, BidEvaluationRecord>
implements BidEvaluationRecordManager {
    @Autowired
    private BidEvaluationDetailManager evaluationDetailManager;
    @Autowired
    private MatApprovalManager matApprovalManager;
    @Autowired
    private MatApprovalDetailsManager matApprovalDetailManager;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private BizBiddingQuotationManager biddingQuotationManager;
    @Autowired
    private ProjectApprovalManager proApprovalManager;
    @Autowired
    private ProjectApprovalDetailsManager proApprovalDetailsManager;

    @Override
    public PageList<BidEvaluationRecord> queryAllByPage(QueryFilter<BidEvaluationRecord> queryFilter) {
        IPage<BidEvaluationRecord> result = ((BidEvaluationRecordDao)this.baseMapper).queryAllByPage((IPage<BidEvaluationRecord>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BidEvaluationRecord>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<BidEvaluationRecord> pageAndDetail(QueryFilter<BidEvaluationRecord> queryFilter) {
        IPage<BidEvaluationRecord> result = ((BidEvaluationRecordDao)this.baseMapper).queryAllByPage((IPage<BidEvaluationRecord>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BidEvaluationRecord>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            for (BidEvaluationRecord temp : records) {
                LambdaQueryWrapper detailQW = new LambdaQueryWrapper();
                detailQW.eq(BidEvaluationDetail::getBidEvaRecordId, (Object)temp.getId());
                temp.setEvaluationDetailList(this.evaluationDetailManager.list((Wrapper)detailQW));
            }
        }
        return new PageList(result);
    }

    @Override
    @Transactional
    public void saveByEva(BidEvaluationRecord entity) {
        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(BidEvaluationRecord::getOperateUserId, (Object)ContextUtil.getCurrentUserId())).eq(BidEvaluationRecord::getNoticeId, (Object)entity.getNoticeId())).eq(BidEvaluationRecord::getNoticeType, (Object)entity.getNoticeType())).eq(BidEvaluationRecord::getQuotationOrgId, (Object)entity.getQuotationOrgId())).last("limit 1");
        BidEvaluationRecord evaHis = (BidEvaluationRecord)((Object)((BidEvaluationRecordDao)this.baseMapper).selectOne((Wrapper)hisQW));
        if (BeanUtils.isNotEmpty((Object)((Object)evaHis))) {
            LambdaQueryWrapper evaDetailHisQW = new LambdaQueryWrapper();
            evaDetailHisQW.eq(BidEvaluationDetail::getBidEvaRecordId, (Object)evaHis.getId());
            this.evaluationDetailManager.remove((Wrapper)evaDetailHisQW);
            super.remove((Serializable)((Object)evaHis.getId()));
        }
        List<BidEvaluationDetail> evaDetailList = entity.getEvaluationDetailList();
        MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());
        entity.setNoticeCode(notice.getProjectNumber());
        entity.setNoticeName(notice.getNoticeTitle());
        entity.setProcureOrgId(notice.getProcureOrgId());
        entity.setProcureOrgCode(notice.getProcureOrgCode());
        entity.setProcureOrgName(notice.getProcureOrgName());
        entity.setEvaluatingMethods(1);
        entity.setEvaluationMode(2);
        entity.setStatus(1);
        super.save((Object)entity);
        evaDetailList.forEach(s -> s.setBidEvaRecordId(entity.getId()));
        this.evaluationDetailManager.saveBatch(evaDetailList);
    }

    @Override
    @Transactional
    public void submitBidEvaluationOrg(BidEvaluationRecord entity) {
        LambdaQueryWrapper dataQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)dataQW.eq(BidEvaluationRecord::getOperateUserId, (Object)ContextUtil.getCurrentUserId())).eq(BidEvaluationRecord::getNoticeId, (Object)entity.getNoticeId())).eq(BidEvaluationRecord::getNoticeType, (Object)entity.getNoticeType());
        List data = super.list((Wrapper)dataQW);
        if (BeanUtils.isEmpty((Object)data) || data.size() <= 0) {
            throw new BaseException("\u6682\u65e0\u8bc4\u6807\u8bb0\u5f55\u53ef\u63d0\u4ea4");
        }
        QueryFilter quoOrgQF = QueryFilter.build();
        quoOrgQF.addFilter("NOTICE_ID_", (Object)entity.getNoticeId(), QueryOP.EQUAL);
        List quoOrgList = this.biddingQuotationManager.evaOrgQuoData((QueryFilter<BizBiddingQuotation>)quoOrgQF).getRows();
        if (quoOrgList.size() != data.size()) {
            throw new BaseException("\u8bf7\u5bf9\u6240\u6709\u6295\u6807\u5355\u4f4d\u8fdb\u884c\u8bc4\u5206\u4fdd\u5b58\u540e\u518d\u8fdb\u884c\u63d0\u4ea4");
        }
        data.stream().forEach(s -> s.setStatus(2));
        super.updateBatchById((Collection)data);
        MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
        LambdaQueryWrapper evaDataQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)evaDataQW.eq(BidEvaluationRecord::getNoticeId, (Object)entity.getNoticeId())).eq(BidEvaluationRecord::getNoticeType, (Object)entity.getNoticeType())).eq(BidEvaluationRecord::getStatus, (Object)2);
        List evaluationRecordList = super.list((Wrapper)evaDataQW);
        List operateUserIds = evaluationRecordList.stream().map(s -> s.getOperateUserId()).distinct().collect(Collectors.toList());
        if (operateUserIds.size() == notice.getEvaluationExpertNumber().intValue()) {
            LambdaQueryWrapper bidEvaHisQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)bidEvaHisQW.eq(BizBidEvaluation::getNoticeId, (Object)entity.getNoticeId())).eq(BizBidEvaluation::getNoticeType, (Object)entity.getNoticeType())).eq(BizModel::getIsDele, (Object)"0");
            this.bidEvaluationManager.remove((Wrapper)bidEvaHisQW);
            Map<String, List<BidEvaluationRecord>> quoOrgGroupMap = evaluationRecordList.stream().collect(Collectors.groupingBy(BidEvaluationRecord::getQuotationOrgId));
            ArrayList bidEvaSaveData = new ArrayList();
            quoOrgGroupMap.forEach((quoOrgId, evaData) -> {
                BizBidEvaluation evaluation = new BizBidEvaluation();
                evaluation.setOperateTime(LocalDateTime.now());
                evaluation.setNoticeId(entity.getNoticeId());
                evaluation.setNoticeCode(notice.getProjectNumber());
                evaluation.setNoticeName(notice.getNoticeTitle());
                evaluation.setNoticeType(entity.getNoticeType());
                evaluation.setProcureOrgId(notice.getProcureOrgId());
                evaluation.setProcureOrgCode(notice.getProcureOrgCode());
                evaluation.setProcureOrgName(notice.getProcureOrgName());
                evaluation.setQuotationOrgId((String)quoOrgId);
                evaluation.setQuotationOrgCode(((BidEvaluationRecord)((Object)((Object)evaData.get(0)))).getQuotationOrgCode());
                evaluation.setQuotationOrgName(((BidEvaluationRecord)((Object)((Object)evaData.get(0)))).getQuotationOrgName());
                evaluation.setQuotationPrice(((BidEvaluationRecord)((Object)((Object)evaData.get(0)))).getQuotationPrice());
                evaluation.setQuotationAmount(((BidEvaluationRecord)((Object)((Object)evaData.get(0)))).getQuotationAmount());
                evaluation.setEvaluatingMethods(1);
                evaluation.setEvaluationMode(2);
                BigDecimal totalScore = BigDecimal.ZERO;
                for (BidEvaluationRecord temp : evaData) {
                    totalScore = totalScore.add(temp.getScore());
                }
                evaluation.setScore(totalScore.divide(new BigDecimal(String.valueOf(evaData.size())), 2));
                evaluation.setStatus(1);
                bidEvaSaveData.add(evaluation);
            });
            this.bidEvaluationManager.saveBatch(bidEvaSaveData);
            if (entity.getNoticeType() == 1) {
                LambdaUpdateWrapper noticeDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeDetailUW.set(MatApprovalDetails::getBidStatus, (Object)2)).eq(MatApprovalDetails::getNoticeId, (Object)notice.getId())).eq(BizModel::getIsDele, (Object)"0");
                this.matApprovalDetailManager.update((Wrapper)noticeDetailUW);
                notice.setBidStatus(6);
                this.matApprovalManager.updateById((Object)notice);
            }
        }
    }

    @Override
    @Transactional
    public void saveByEvaMat(BidEvaluationRecord entity) {
        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(BidEvaluationRecord::getOperateUserId, (Object)ContextUtil.getCurrentUserId())).eq(BidEvaluationRecord::getNoticeId, (Object)entity.getNoticeId())).eq(BidEvaluationRecord::getNoticeType, (Object)entity.getNoticeType())).eq(BidEvaluationRecord::getNoticeDetailedId, (Object)entity.getNoticeDetailedId())).eq(BidEvaluationRecord::getQuotationOrgId, (Object)entity.getQuotationOrgId())).last("limit 1");
        BidEvaluationRecord evaHis = (BidEvaluationRecord)((Object)((BidEvaluationRecordDao)this.baseMapper).selectOne((Wrapper)hisQW));
        if (BeanUtils.isNotEmpty((Object)((Object)evaHis))) {
            LambdaQueryWrapper evaDetailHisQW = new LambdaQueryWrapper();
            evaDetailHisQW.eq(BidEvaluationDetail::getBidEvaRecordId, (Object)evaHis.getId());
            this.evaluationDetailManager.remove((Wrapper)evaDetailHisQW);
            super.remove((Serializable)((Object)evaHis.getId()));
        }
        List<BidEvaluationDetail> evaDetailList = entity.getEvaluationDetailList();
        if (entity.getNoticeType() == 1) {
            MatApproval notice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
            entity.setNoticeCode(notice.getProjectNumber());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
        } else {
            ProjectApproval notice = (ProjectApproval)((Object)this.proApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
            entity.setNoticeCode(notice.getNoticeCode());
            entity.setNoticeName(notice.getNoticeTitle());
            entity.setProcureOrgId(notice.getProcureOrgId());
            entity.setProcureOrgCode(notice.getProcureOrgCode());
            entity.setProcureOrgName(notice.getProcureOrgName());
        }
        entity.setOperateTime(LocalDateTime.now());
        entity.setOperateUserId(ContextUtil.getCurrentUserId());
        entity.setOperateUserName(ContextUtil.getCurrentUserName());
        entity.setEvaluatingMethods(1);
        entity.setEvaluationMode(1);
        entity.setStatus(1);
        super.save((Object)entity);
        evaDetailList.forEach(s -> s.setBidEvaRecordId(entity.getId()));
        this.evaluationDetailManager.saveBatch(evaDetailList);
    }

    @Override
    @Transactional
    public void submitBidEvaluation(BidEvaluationRecord entity) {
        LambdaQueryWrapper dataQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)dataQW.eq(BidEvaluationRecord::getOperateUserId, (Object)ContextUtil.getCurrentUserId())).eq(BidEvaluationRecord::getNoticeId, (Object)entity.getNoticeId())).eq(BidEvaluationRecord::getNoticeType, (Object)entity.getNoticeType())).eq(BidEvaluationRecord::getNoticeDetailedId, (Object)entity.getNoticeDetailedId());
        List data = super.list((Wrapper)dataQW);
        if (BeanUtils.isEmpty((Object)data) || data.size() <= 0) {
            throw new BaseException("\u6682\u65e0\u8bc4\u6807\u8bb0\u5f55\u53ef\u63d0\u4ea4");
        }
        QueryFilter quoOrgQF = QueryFilter.build();
        quoOrgQF.addFilter("NOTICE_ID_", (Object)entity.getNoticeId(), QueryOP.EQUAL);
        quoOrgQF.addFilter("NOTICE_DETAILED_ID_", (Object)entity.getNoticeDetailedId(), QueryOP.EQUAL);
        List quoOrgList = this.biddingQuotationManager.pageQuoOrg((QueryFilter<BizBiddingQuotation>)quoOrgQF).getRows();
        if (quoOrgList.size() != data.size()) {
            throw new BaseException("\u8bf7\u5bf9\u8be5\u7269\u6599\u6240\u6709\u6295\u6807\u5355\u4f4d\u8fdb\u884c\u8bc4\u5206\u4fdd\u5b58\u540e\u518d\u8fdb\u884c\u63d0\u4ea4");
        }
        data.stream().forEach(s -> s.setStatus(2));
        super.updateBatchById((Collection)data);
        Integer evaExpertNumber = null;
        MatApproval matNotice = (MatApproval)((Object)this.matApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
        ProjectApproval proNotice = (ProjectApproval)((Object)this.proApprovalManager.getById((Serializable)((Object)entity.getNoticeId())));
        evaExpertNumber = entity.getNoticeType() == 1 ? matNotice.getEvaluationExpertNumber() : proNotice.getEvaluationExpertNumber();
        LambdaQueryWrapper evaCountQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaCountQW.eq(BidEvaluationRecord::getNoticeId, (Object)entity.getNoticeId())).eq(BidEvaluationRecord::getNoticeType, (Object)entity.getNoticeType())).eq(BidEvaluationRecord::getNoticeDetailedId, (Object)entity.getNoticeDetailedId())).eq(BidEvaluationRecord::getStatus, (Object)2);
        List evaluationRecordList = super.list((Wrapper)evaCountQW);
        List evaUserList = evaluationRecordList.stream().map(s -> s.getOperateUserId()).distinct().collect(Collectors.toList());
        if (evaUserList.size() == evaExpertNumber.intValue()) {
            LambdaQueryWrapper bidEvaHisQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)bidEvaHisQW.eq(BizBidEvaluation::getNoticeId, (Object)entity.getNoticeId())).eq(BizBidEvaluation::getNoticeDetailedId, (Object)entity.getNoticeDetailedId())).eq(BizModel::getIsDele, (Object)"0");
            this.bidEvaluationManager.remove((Wrapper)bidEvaHisQW);
            Map<String, List<BidEvaluationRecord>> collect = evaluationRecordList.stream().collect(Collectors.groupingBy(BidEvaluationRecord::getNoticeDetailedId));
            collect.forEach((noticeDetailId, evaList) -> {
                Map<String, List<BidEvaluationRecord>> tempList = evaList.stream().collect(Collectors.groupingBy(BidEvaluationRecord::getQuotationOrgId));
                tempList.forEach((quoOrgId, evaData) -> {
                    BidEvaluationRecord evaTemp = (BidEvaluationRecord)((Object)((Object)((Object)evaData.get(0))));
                    BizBidEvaluation evaluation = new BizBidEvaluation();
                    evaluation.setOperateTime(LocalDateTime.now());
                    evaluation.setNoticeType(evaTemp.getNoticeType());
                    evaluation.setNoticeId(evaTemp.getNoticeId());
                    evaluation.setNoticeCode(evaTemp.getNoticeCode());
                    evaluation.setNoticeName(evaTemp.getNoticeName());
                    evaluation.setNoticeDetailedId(evaTemp.getNoticeDetailedId());
                    evaluation.setProcureOrgId(evaTemp.getProcureOrgId());
                    evaluation.setProcureOrgCode(evaTemp.getProcureOrgCode());
                    evaluation.setProcureOrgName(evaTemp.getProcureOrgName());
                    evaluation.setQuotationOrgId(evaTemp.getQuotationOrgId());
                    evaluation.setQuotationOrgCode(evaTemp.getQuotationOrgCode());
                    evaluation.setQuotationOrgName(evaTemp.getQuotationOrgName());
                    evaluation.setQuotationPrice(evaTemp.getQuotationPrice());
                    evaluation.setQuotationAmount(evaTemp.getQuotationAmount());
                    evaluation.setEvaluatingMethods(1);
                    evaluation.setEvaluationMode(1);
                    BigDecimal totalScore = BigDecimal.ZERO;
                    for (BidEvaluationRecord temp : evaData) {
                        totalScore = totalScore.add(temp.getScore());
                    }
                    evaluation.setScore(totalScore.divide(new BigDecimal(String.valueOf(evaData.size())), 2));
                    evaluation.setStatus(1);
                    this.bidEvaluationManager.save((Object)evaluation);
                });
            });
            if (entity.getNoticeType() == 1) {
                LambdaUpdateWrapper noticeDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeDetailUW.set(MatApprovalDetails::getBidStatus, (Object)2)).eq(MatApprovalDetails::getId, (Object)entity.getNoticeDetailedId())).eq(BizModel::getIsDele, (Object)"0");
                this.matApprovalDetailManager.update((Wrapper)noticeDetailUW);
                LambdaQueryWrapper approvalDetailQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)approvalDetailQW.eq(MatApprovalDetails::getBidStatus, (Object)1)).eq(MatApprovalDetails::getNoticeId, (Object)entity.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
                if (this.matApprovalDetailManager.count((Wrapper)approvalDetailQW) == 0) {
                    matNotice.setBidStatus(6);
                    this.matApprovalManager.updateById((Object)matNotice);
                }
            } else {
                LambdaUpdateWrapper noticeDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeDetailUW.set(ProjectApprovalDetails::getBidStatus, (Object)2)).eq(ProjectApprovalDetails::getId, (Object)entity.getNoticeDetailedId())).eq(BizModel::getIsDele, (Object)"0");
                this.proApprovalDetailsManager.update((Wrapper)noticeDetailUW);
                LambdaQueryWrapper approvalDetailQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)approvalDetailQW.eq(ProjectApprovalDetails::getBidStatus, (Object)1)).eq(ProjectApprovalDetails::getNoticeId, (Object)entity.getNoticeId())).eq(BizModel::getIsDele, (Object)"0");
                if (this.proApprovalDetailsManager.count((Wrapper)approvalDetailQW) == 0) {
                    proNotice.setBidStatus(6);
                    this.proApprovalManager.updateById((Object)proNotice);
                }
            }
        }
    }
}

