import htbComponent from '@/components/common/TabsComponent.vue'
export default [
  /* 空菜单  */
  {
    path: 'empty',
    name: 'empty',
    component: () => import('@/views/empty.vue'),
    meta: {
      anonymous: true
    }
  },
  /* 审核中心 --- 我的传阅  */
  {
    path: 'myRead',
    name: 'myRead',
    component: () =>
      import('@/views/Normal/AuditCenter/myRead/myRead.vue')
  },
  /* 基础数据 --- 数据共享  */
  {
    path: 'dataSharing',
    name: 'dataSharing',
    component: () =>
      import('@/views/Normal/BasicDataManagement/dataSharing/index.vue')
  },
  /* 基础数据 --- 新增修改数据共享  */
  {
    path: 'addSharing',
    name: 'addSharing',
    component: () =>
      import('@/views/Normal/BasicDataManagement/dataSharing/component/addSharing.vue')
  },
  /* 基础数据 --- 物料管理  */
  {
    path: 'materialManagement',
    name: 'materialManagement',
    component: () =>
      import('@/views/Normal/BasicDataManagement/materialManagement/index.vue')
  },
  /* 基础数据 --- 物料分类详情  */
  {
    path: 'materialDetail',
    name: 'materialDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/materialManagement/component/materialDetail.vue'
      )
  },
  /* 基础数据 --- 物料分类新增修改  */
  {
    path: 'materialeditAddDialog',
    name: 'materialeditAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/materialManagement/component/materialeditAddDialog.vue'
      )
  },
  /* 基础数据 --- 平台物料  */
  {
    path: 'platformMaterials',
    name: 'platformMaterials',
    component: () =>
      import('@/views/Normal/BasicDataManagement/platformManage/index.vue')
  },
  /* 基础数据 --- 平台物料编辑  */
  {
    path: 'platAddDialog',
    name: 'platAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/platformManage/component/platAddDialog.vue'
      )
  },

  /* 基础数据 --- 物料数据详情  */
  {
    path: 'informationDetail',
    name: 'informationDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/materialManagement/component/informationDetail.vue'
      )
  },
  /* 基础数据 --- 物料数据新增修改  */
  {
    path: 'informationAddDialog',
    name: 'informationAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/materialManagement/component/informationAddDialog.vue'
      )
  },
  /* 基础数据 --- 企业库  */
  {
    path: 'enterpriseLibrary',
    name: 'enterpriseLibrary',
    component: () =>
      import('@/views/Normal/BasicDataManagement/enterpriseLibrary/index.vue')
  },
  /* 基础数据 --- 资质管理  */
  {
    path: 'qualificationManagement',
    name: 'qualificationManagement',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/qualificationManagement/index.vue'
      )
  },
  /* 基础数据 --- 资质配置新增修改  */
  {
    path: 'qualificationType',
    name: 'qualificationType',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/qualificationType/qualificationType.vue'
      )
  },
  /* 基础数据 --- 资质配置新增修改  */
  {
    path: 'qualificationAddDialog',
    name: 'qualificationAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/qualificationType/qualificationAddDialog.vue'
      )
  },
  /* 基础数据 --- 资质配置详情  */
  {
    path: 'qualificationDetail',
    name: 'qualificationDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/qualificationType/qualificationDetail.vue'
      )
  },
  /* 基础数据 --- 资质管理资质库新增修改  */
  {
    path: 'libraryAddDialog',
    name: 'libraryAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/qualificationManagement/component/libraryAddDialog.vue'
      )
  },
  /* 基础数据 --- 资质管理资质库详情  */
  {
    path: 'libraryDetail',
    name: 'libraryDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/qualificationManagement/component/libraryDetail.vue'
      )
  },
  /* 基础数据 --- 资质管理资质库资质库变更记录  */
  {
    path: 'libraryAddDialogRecording',
    name: 'libraryAddDialogRecording',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/qualificationManagement/component/libraryAddDialogRecording.vue'
      )
  },
  /* 基础数据 --- 专家分类  */
  {
    path: 'classificationExperts',
    name: 'classificationExperts',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/expertManagement/component/classificationExperts.vue'
      )
  },
  /* 基础数据 --- 专家库  */
  {
    path: 'expertPool',
    name: 'expertPool',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/expertManagement/component/expertPool.vue'
      )
  },
  /* 基础数据 --- 专家管理  新增修改  */
  {
    path: 'classificationAddDialog',
    name: 'classificationAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/expertManagement/component/classificationAddDialog.vue'
      )
  },
  /* 基础数据 --- 专家管理 专家分类 详情  */
  {
    path: 'classificationDetail',
    name: 'classificationDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/expertManagement/component/classificationDetail.vue'
      )
  },
  /* 基础数据 --- 专家管理 专家库 新增修改  */
  {
    path: 'expertPoolAddDialog',
    name: 'expertPoolAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/expertManagement/component/expertPoolAddDialog.vue'
      )
  },
  /* 基础数据 --- 专家管理 专家库 详情  */
  {
    path: 'expertDetail',
    name: 'expertDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/expertManagement/component/expertDetail.vue'
      )
  },
  /* 基础数据 --- 用户目录  */
  {
    path: 'userDirectory',
    name: 'userDirectory',
    component: () =>
      import('@/views/Normal/BasicDataManagement/userDirectory/index.vue')
  },

  /* 基础数据 --- 评标体系  */
  {
    path: 'evaluationSystem',
    name: 'evaluationSystem',
    component: () =>
      import('@/views/Normal/BasicDataManagement/evaluationSystem/index.vue')
  },
  /* 基础数据 --- 评标体系 综合评标法  新增修改*/
  {
    path: 'methodAddDialog',
    name: 'methodAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/evaluationSystem/component/methodAddDialog.vue'
      )
  },
  /* 基础数据 --- 评标体系 综合评标法  详情*/
  {
    path: 'methodDetail',
    name: 'methodDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/evaluationSystem/component/methodDetail.vue'
      )
  },
  /* 基础数据 --- 评标体系 最低价评标法  新增修改*/
  {
    path: 'lowestAddDialog',
    name: 'lowestAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/evaluationSystem/component/lowestAddDialog.vue'
      )
  },
  /* 基础数据 --- 评标体系 最低价评标法  详情*/
  {
    path: 'lowestDetail',
    name: 'lowestDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/evaluationSystem/component/lowestDetail.vue'
      )
  },
  /* 基础数据 --- 评标体系 --- 评标项管理 新增修改 */
  {
    path: 'evaluationManagementAddDialog',
    name: 'evaluationManagementAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/evaluationSystem/component/evaluationManagementAddDialog.vue'
      )
  },
  /* 基础数据 --- 评标体系 --- 评标项管理 详情 */
  {
    path: 'evaluationManagementDetail',
    name: 'evaluationManagementDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/evaluationSystem/component/evaluationManagementDetail.vue'
      )
  },
  /* 基础数据 --- 报价模板  */
  {
    path: 'quoteTemplate',
    name: 'quoteTemplate',
    component: () =>
      import('@/views/Normal/BasicDataManagement/quoteTemplate/index.vue')
  },
  /* 基础数据 --- 报价模板 --- 新增修改 */
  {
    path: '/quoteTemplateAddDialog/:id?',
    name: 'quoteTemplateAddDialog',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/quoteTemplate/component/quoteTemplateAddDialog.vue'
      )
  },
  /* 基础数据 --- 报价模板 --- 详情 */
  {
    path: '/quoteTemplateDetail/:id?',
    name: 'quoteTemplateDetail',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/quoteTemplate/component/quoteTemplateDetail.vue'
      )
  },
  /* 基础数据 --- 审核设置  */
  {
    path: 'auditSettings',
    name: 'auditSettings',
    component: () =>
      import('@/views/Normal/BasicDataManagement/auditSettings/index.vue')
  },
  /* 基础数据 --- 审核设置新增  */
  {
    path: 'add',
    name: 'add',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/auditSettings/component/add.vue'
      )
  },
  /* 基础数据 --- 准入规则  */
  {
    path: 'accessRule',
    name: 'accessRule',
    component: () =>
      import('@/views/Normal/BasicDataManagement/accessRule/index.vue')
  },
  /* 基础数据 --- 准入规则 -- 新增编辑  */
  {
    path: 'addRule',
    name: 'addRule',
    component: () =>
      import(
        '@/views/Normal/BasicDataManagement/accessRule/component/addRule.vue'
      )
  },
  /* 基础数据 --- 产品  */
  {
    path: 'productLibrary',
    name: 'productLibrary',
    component: () =>
      import('@/views/Normal/BasicDataManagement/productLibrary/index.vue')
  },
  /* 基础数据 --- 产品新增  */
  {
    path: 'addLibrary',
    name: 'addLibrary',
    component: () =>
      import('@/views/Normal/BasicDataManagement/productLibrary/component/addLibrary.vue')
  },
  /* 基础数据 --- 物料分级管理  */
  {
    path: 'materialGradeManage',
    name: 'materialGradeManage',
    component: () =>
      import('@/views/Normal/BasicDataManagement/materialGradeManage/materialGradeManage.vue')
  },
  /* 基础数据 --- 物料分级管理新增编辑  */
  {
    path: 'addGradeManage',
    name: 'addGradeManage',
    component: () =>
      import('@/views/Normal/BasicDataManagement/materialGradeManage/component/addGradeManage.vue')
  },
  /* 审核中心 --- 待办任务  */
  {
    path: 'toDoTask',
    name: 'toDoTask',
    component: () => import('@/views/Normal/AuditCenter/toDoTask/index.vue')
  },
  /* 审核中心 --- 已办任务  */
  {
    path: 'completedTasks',
    name: 'completedTasks',
    component: () =>
      import('@/views/Normal/AuditCenter/completedTasks/index.vue')
  },
  /* 审核中心 --- 我的请求  */
  {
    path: 'myRequest',
    name: 'myRequest',
    component: () => import('@/views/Normal/AuditCenter/myRequest/index.vue')
  },
  /* 供应商管理 --- 供应商退出  */
  {
    path: 'supplierWithdrawal',
    name: 'supplierWithdrawal',
    component: () =>
      import('@/views/Normal/SupplierManagement/supplierWithdrawal/index.vue')
  },
  /* 供应商管理 --- 企业目录  */
  {
    path: 'affiliatedEnterprise',
    name: 'affiliatedEnterprise',
    component: () =>
      import('@/views/Normal/SupplierManagement/affiliatedEnterprise/index.vue')
  },
  /* 供应商管理 --- 供应商审核  */
  {
    path: 'supplierAudit',
    name: 'supplierAudit',
    component: () =>
      import('@/views/Normal/SupplierManagement/supplierAudit/index.vue')
  },
  /* 供应商管理 --- 供应商准入  */
  {
    path: 'onboardingSupplier',
    name: 'onboardingSupplier',
    component: () =>
      import('@/views/Normal/SupplierManagement/onboardingSupplier/index.vue')
  },
  /* 供应商管理 --- 供应商准入 -- 供应商问题清单  */
  {
    path: '/supplierIssueList/:supplierId/:enterpriseId',
    name: 'supplierIssueList',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/onboardingSupplier/supplierIssueList.vue'
      )
  },
  /* 供应商管理 --- 供应商准入 -- 供应商问题清单 --新增问题清单  */
  {
    path: 'addQuerstion',
    name: 'addQuerstion',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/onboardingSupplier/module/addQuerstion.vue'
      )
  },
  /* 供应商管理 --- 企业邀请  */
  {
    path: 'enterpriseInvitation',
    name: 'enterpriseInvitation',
    component: () =>
      import('@/views/Normal/SupplierManagement/enterpriseInvitation/index.vue')
  },
  /* 供应商管理 --- 企业邀请新增修改  */
  {
    path: 'addDialog',
    name: 'addDialog',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/enterpriseInvitation/component/addDialog.vue'
      )
  },
  // /* 供应商管理 --- 临时供应商  */
  {
    path: 'temporarySupplier',
    name: 'temporarySupplier',
    component: () =>
      import('@/views/Normal/SupplierManagement/temporarySupplier/index.vue')
  },
  // /* 供应商管理 --- 临时供应商 --新增修改  */
  {
    path: '/addTemporaryEnterprise/:id?',
    name: 'addTemporaryEnterprise',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/temporarySupplier/component/addTemporaryEnterprise.vue'
      )
  },
  /* 供应商管理 --- 供应商管理 新增修改  */
  {
    path: '/onboardingAddDialog/:id?',
    name: 'onboardingAddDialog',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/onboardingSupplier/component/onboardingAddDialog.vue'
      )
  },
  /* 供应商管理 --- 供应商管理 详情  */
  {
    path: '/onboardingDetail/:id?',
    name: 'onboardingDetail',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/onboardingSupplier/component/onboardingDetail.vue'
      )
  },
  /* 供应商管理 --- 供应商分类分级  */
  {
    path: 'classificationSupplier',
    name: 'classificationSupplier',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/classificationSupplier/index.vue'
      )
  },
  /* 供应商管理 --- 供应商分类分级 新增修改  */
  {
    path: '/supplierAddDialog/:id?',
    name: 'supplierAddDialog',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/classificationSupplier/component/supplierAddDialog.vue'
      )
  },
  /* 供应商管理 --- 供应商分类分级 详情  */
  {
    path: '/supplierDetail/:id?',
    name: 'supplierDetail',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/classificationSupplier/component/supplierDetail.vue'
      )
  },
  /* 供应商管理 --- 供应商黑名单  */
  {
    path: 'blacklistSupplier',
    name: 'blacklistSupplier',
    component: () =>
      import('@/views/Normal/SupplierManagement/blacklistSupplier/index.vue')
  },
  /* 供应商管理 --- 供应商黑名单 新增修改  */
  {
    path: '/blacklistAddDialog/:id?',
    name: 'blacklistAddDialog',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/blacklistSupplier/component/blacklistAddDialog.vue'
      )
  },
  /* 供应商管理 --- 供应商黑名单 详情  */
  {
    path: '/blacklistDetail/:id?',
    name: 'blacklistDetail',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/blacklistSupplier/component/blacklistDetail.vue'
      )
  },
  /* 供应商管理 --- 企业评价  */
  {
    path: 'enterpriseEvaluation',
    name: 'enterpriseEvaluation',
    component: () =>
      import('@/views/Normal/SupplierManagement/enterpriseEvaluation/index.vue')
  },
  /* 供应商管理 --- 企业评价 新增修改  */
  {
    path: '/evaluationAddDialog/:id?',
    name: 'evaluationAddDialog',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/enterpriseEvaluation/component/evaluationAddDialog.vue'
      )
  },
  /* 供应商管理 --- 企业评价 详情  */
  {
    path: '/evaluationDetail/:id?',
    name: 'evaluationDetail',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/enterpriseEvaluation/component/evaluationDetail.vue'
      )
  },
  /* 供应商管理 --- 运营评价  */
  {
    path: 'operationalEvaluation',
    name: 'operationalEvaluation',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/operationalEvaluation/index.vue'
      )
  },
  /* 供应商管理 --- 供应商评价  */
  {
    path: 'supplierEvaluation',
    name: 'supplierEvaluation',
    component: () =>
      import('@/views/Normal/SupplierManagement/supplierEvaluation/index.vue')
  },
  /* 供应商管理 --- 供应商评价-新增编辑  */
  {
    path: '/supplierDialog/:id?',
    name: 'supplierDialog',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/supplierEvaluation/component/supplierDialog.vue'
      )
  },
  /* 供应商管理 --- 送货地址管理  */
  {
    path: 'addressManagement',
    name: 'addressManagement',
    component: () =>
      import('@/views/Normal/SupplierManagement/addressManagement/index.vue')
  },
  /* 供应商管理 --- 送货地址管理 --新增修改  */
  {
    path: '/addressDialog/:id?',
    name: 'addressDialog',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/addressManagement/component/addressDialog.vue'
      )
  },

  /* 供应商管理 --- 框架协议管理  */
  {
    path: 'frameworkProtocol',
    name: 'frameworkProtocol',
    component: () =>
      import('@/views/Normal/SupplierManagement/frameworkProtocol/index.vue')
  },
  /* 供应商管理 --- 问题清单  */
  {
    path: 'questionsList',
    name: 'questionsList',
    component: () =>
      import('@/views/Normal/SupplierManagement/questionsList/index.vue')
  },
  /* 供应商管理 --- 问题清单  */
  {
    path: 'addQuestionDialog',
    name: 'addQuestionDialog',
    component: () =>
      import(
        '@/views/Normal/SupplierManagement/questionsList/component/addQuestionDialog.vue'
      )
  },
  /* 物资采购 --- 采购申请集成  */
  {
    path: 'procurementIntegration',
    name: 'procurementIntegration',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/procurementIntegration/index.vue'
      )
  },
  /* 物资采购 --- 采购申请集成新增修改  */
  {
    path: 'integrationAddDialog',
    name: 'integrationAddDialog',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/procurementIntegration/component/integrationAddDialog.vue'
      )
  },
  /* 物资采购 --- 采购申请集成详情  */
  {
    path: 'integrationDetail',
    name: 'integrationDetail',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/procurementIntegration/component/integrationDetail.vue'
      )
  },
  /* 物资采购 --- 采购申请  */
  {
    path: 'purchaseRequisition',
    name: 'purchaseRequisition',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/purchaseRequisition/index.vue'
      )
  },
  /* 物资采购 --- 采购申请管理  */
  {
    path: 'applyProcurement',
    name: 'applyProcurement',
    component: () =>
      import('@/views/Normal/ProcurementManagement/applyProcurement/index.vue')
  },
  /* 物资采购 --- 采购申请--明细  */
  {
    path: 'applyDetails',
    name: 'applyDetails',
    component: () =>
      import('@/views/Normal/ProcurementManagement/applyProcurement/component/applyDetails.vue')
  },
  /* 物资采购 --- 采购申请 新增修改  */
  {
    path: 'purchaseAddDialog',
    name: 'purchaseAddDialog',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/purchaseRequisition/component/purchaseAddDialog.vue'
      )
  },
  /* 物资采购 --- 采购申请 详情  */
  {
    path: 'purchaseDetail',
    name: 'purchaseDetail',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/purchaseRequisition/component/purchaseDetail.vue'
      )
  },
  /* 物资采购 --- 采购立项  */
  {
    path: 'approvalProcurement',
    name: 'approvalProcurement',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/approvalProcurement/index.vue'
      )
  },
  /* 物资采购 --- 采购立项 新增修改  */
  {
    path: 'approvalAddDialog',
    name: 'approvalAddDialog',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/approvalProcurement/component/approvalAddDialog.vue'
      )
  },
  /* 物资采购 --- 采购立项 详情  */
  {
    path: 'approvalDetail',
    name: 'approvalDetail',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/approvalProcurement/component/approvalDetail.vue'
      )
  },
  /* 物资采购 --- 设备库  */
  {
    path: 'equipmentLibrary',
    name: 'equipmentLibrary',
    component: () =>
      import('@/views/Normal/ProcurementManagement/equipmentLibrary/index.vue')
  },
  /* 物资采购 --- 设备库 新增修改  */
  {
    path: 'addEquipmentLibrary',
    name: 'addEquipmentLibrary',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/equipmentLibrary/component/addEquipmentLibrary.vue'
      )
  },
  /* 物资采购 --- 采购管理  */
  {
    path: 'materialProjectManagement',
    name: 'materialProjectManagement',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/materialProjectManagement/index.vue'
      )
  },

  /* 物资采购 --- 采购管理 查看  */
  {
    path: 'approvalAdd',
    name: 'approvalAdd',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/materialProjectManagement/component/approvalAdd.vue'
      )
  },
  /* 物资采购 --- 多轮采购  */
  {
    path: 'multipleRoundsApproval',
    name: 'multipleRoundsApproval',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/multipleRoundsApproval/index.vue'
      )
  },
  /* 物资采购 --- 多轮采购新增  */
  {
    path: 'multApprovalAddDialog',
    name: 'multApprovalAddDialog',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/multipleRoundsApproval/component/multApprovalAddDialog.vue'
      )
  },
  /* 物资采购 --- 多轮采购详情  */
  {
    path: 'mutApprovalDetail',
    name: 'mutApprovalDetail',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/multipleRoundsApproval/component/mutApprovalDetail.vue'
      )
  },
  /* 物资采购 --- 补遗管理  */
  {
    path: 'supplementManage',
    name: 'supplementManage',
    component: () =>
      import('@/views/Normal/ProcurementManagement/supplementManage/index.vue')
  },
  /* 物资采购 --- 澄清管理  */
  {
    path: 'clarificationManagement',
    name: 'clarificationManagement',
    component: () =>
      import(
        '@/views/Normal/ProcurementManagement/clarificationManagement/index.vue'
      )
  },
  /* 项目采购管理 --- 项目基础信息  */
  {
    path: 'basicProject',
    name: 'basicProject',
    component: () =>
      import('@/views/Normal/ProjectManagement/basicProject/index.vue')
  },
  /* 物资采购 --- 项目基础信息 新增修改  */
  {
    path: 'basicAddDialog',
    name: 'basicAddDialog',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/basicProject/component/basicAddDialog.vue'
      )
  },
  /* 项目采购 --- 项目基础信息 详情  */
  {
    path: 'basicDetail',
    name: 'basicDetail',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/basicProject/component/basicDetail.vue'
      )
  },
  /* 项目采购管理 --- 采购申请  */
  {
    path: 'projectPurchaseRequisition',
    name: 'projectPurchaseRequisition',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/projectPurchaseRequisition/index.vue'
      )
  },
  /* 项目采购 --- 采购申请 新增修改  */
  {
    path: 'projectPurchaseAddDialog',
    name: 'projectPurchaseAddDialog',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/projectPurchaseRequisition/component/projectPurchaseAddDialog.vue'
      )
  },
  /* 项目采购 --- 采购申请 详情  */
  {
    path: 'projectPurchaseDetail',
    name: 'projectPurchaseDetail',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/projectPurchaseRequisition/component/projectPurchaseDetail.vue'
      )
  },
  /* 项目采购管理 --- 采购立项  */
  {
    path: 'projectProcurementApproval',
    name: 'projectProcurementApproval',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/projectProcurementApproval/index.vue'
      )
  },
  /* 项目采购 --- 采购立项 新增修改  */
  {
    path: 'projectApprovalAddDialog',
    name: 'projectApprovalAddDialog',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/projectProcurementApproval/component/projectApprovalAddDialog.vue'
      )
  },
  /* 项目采购 --- 采购立项 详情  */
  {
    path: 'projectApprovalDetail',
    name: 'projectApprovalDetail',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/projectProcurementApproval/component/projectApprovalDetail.vue'
      )
  },
  /* 项目采购 --- 项目台账  */
  {
    path: 'projectLedger',
    name: 'projectLedger',
    component: () =>
      import('@/views/Normal/ProjectManagement/projectLedger/index.vue')
  },
  /* 项目采购 --- 项目台账新增修改  */
  {
    path: 'addLedger',
    name: 'addLedger',
    component: () =>
      import(
        '@/views/Normal/ProjectManagement/projectLedger/component/addLedger.vue'
      )
  },
  /* 投标管理 --- 参与报名  */
  {
    path: 'participateRegistration',
    name: 'participateRegistration',
    component: () =>
      import('@/views/Normal/ManagementBid/participateRegistration/index.vue')
  },
  /* 投标管理 --- 物资采购  */
  {
    path: 'participateRecording/:type',
    name: 'participateRecording',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/participateRegistration/component/participateRecording.vue'
      )
  },
  /* 投标管理 --- 项目采购  */
  {
    path: 'projectRecording',
    name: 'projectRecording',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/participateRegistration/component/projectRecording.vue'
      )
  },
  /* 投标管理 --- 我的报价  */
  {
    path: 'quotesMy',
    name: 'quotesMy',
    component: () => import('@/views/Normal/ManagementBid/quotesMy/index.vue')
  },
  /* 投标管理 --- 我的报价 招标 前往报价  */
  {
    path: '/tendeRecording/:id?/:method?',
    name: 'tendeRecording',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotesMy/component/tendeRecording.vue'
      )
  },
  /* 投标管理 --- 我的报价 招标 限时竞价  */
  {
    path: '/tendeLimited/:id?/:method?',
    name: 'tendeLimited',
    component: () =>
      import('@/views/Normal/ManagementBid/quotesMy/component/tendeLimited.vue')
  },
  /* 投标管理 --- 我的报价 竞价 前往报价  */
  {
    path: 'biddingRecording',
    name: 'biddingRecording',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotesMy/component/biddingRecording.vue'
      )
  },
  /* 投标管理 --- 我的报价 询价 前往报价  */
  {
    path: 'inquiryRecording',
    name: 'inquiryRecording',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotesMy/component/inquiryRecording.vue'
      )
  },
  /* 投标管理 --- 我的报价 竞争性谈判 前往报价  */
  {
    path: '/negotiationsRecording/:id?/:method?',
    name: 'negotiationsRecording',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotesMy/component/negotiationsRecording.vue'
      )
  },
  /* 投标管理 --- 我的报价 竞争性谈判 前往报价  */
  {
    path: '/negotiationsLimited:id?/:method?',
    name: 'negotiationsLimited',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotesMy/component/negotiationsLimited.vue'
      )
  },
  /* 投标管理 --- 报价现场  */
  {
    path: 'quotationSite',
    name: 'quotationSite',
    component: () =>
      import('@/views/Normal/ManagementBid/quotationSite/index.vue')
  },
  /* 投标管理 --- 报价现场 物资采购 查看明细  */
  {
    path: 'tendeSiteDetails',
    name: 'tendeSiteDetails',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotationSite/component/tendeSiteDetails.vue'
      )
  },
  /* 投标管理 --- 报价现场 物资采购 查看报价  */
  {
    path: '/tendeSiteQuote/:ids?',
    name: 'tendeSiteQuote',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotationSite/component/tendeSiteQuote.vue'
      )
  },
  /* 投标管理 --- 报价现场 物资采购 报价详情 */
  {
    path: '/tendeSiteRecording/:ids?',
    name: 'tendeSiteRecording',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotationSite/component/tendeSiteRecording.vue'
      )
  },
  /* 投标管理 --- 报价现场 项目采购 查看明细  */
  {
    path: 'negotiationsDetails',
    name: 'negotiationsDetails',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotationSite/component/negotiationsDetails.vue'
      )
  },
  /* 投标管理 --- 报价现场 项目采购 查看报价  */
  {
    path: 'negotiationsQuote',
    name: 'negotiationsQuote',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotationSite/component/negotiationsQuote.vue'
      )
  },
  /* 投标管理 --- 报价现场 项目采购 报价详情  */
  {
    path: 'negotiationsSiteRecording',
    name: 'negotiationsSiteRecording',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/quotationSite/component/negotiationsSiteRecording.vue'
      )
  },
  /* 投标管理 --- 开标管理  */
  {
    path: 'bidOpeningManagement',
    name: 'bidOpeningManagement',
    component: () =>
      import('@/views/Normal/ManagementBid/bidOpeningManagement/index.vue')
  },
  /* 投标管理 --- 评标管理  */
  {
    path: 'evaluationBid',
    name: 'evaluationBid',
    component: () =>
      import('@/views/Normal/ManagementBid/evaluationBid/index.vue')
  },
  /* 投标管理 --- 物资采购 查看明细 */
  {
    path: 'procurementDetails',
    name: 'procurementDetails',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationBid/component/procurementDetails.vue'
      )
  },
  /* 投标管理 --- 物资采购 评标 */
  {
    path: '/procurementBid/:ids?',
    name: 'procurementBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationBid/component/procurementBid.vue'
      )
  },
  /* 投标管理 --- 物资采购 最低评标 */
  {
    path: '/minProcurementBid/:ids?',
    name: 'minProcurementBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationBid/component/minProcurementBid.vue'
      )
  },
  /* 投标管理 --- 项目采购 查看明细 */
  {
    path: 'projectProcureDetails',
    name: 'projectProcureDetails',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationBid/component/projectProcureDetails.vue'
      )
  },
  /* 投标管理 --- 项目采购 评标 */
  {
    path: '/projectProcureBid/:id?',
    name: 'projectProcureBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationBid/component/projectProcureBid.vue'
      )
  },
  /* 投标管理 --- 物资采购 最低评标 */
  {
    path: '/minProjectProcureBid/:id?',
    name: 'minProjectProcureBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationBid/component/minProjectProcureBid.vue'
      )
  },
  /* 投标管理 --- 定标管理  */
  {
    path: 'calibration',
    name: 'calibration',
    component: () =>
      import('@/views/Normal/ManagementBid/calibration/index.vue')
  },
  /* 投标管理 --- 定标管理 物资采购  查看明细*/
  {
    path: 'materialProcurementDetails',
    name: 'materialProcurementDetails',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/calibration/component/materialProcurementDetails.vue'
      )
  },
  /* 投标管理 --- 定标管理 物资采购 评标确认*/
  {
    path: 'materialProcurementConfirm/:id',
    name: 'materialProcurementConfirm',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/calibration/component/materialProcurementConfirm.vue'
      )
  },
  /* 投标管理 --- 定标管理 物资采购 综合评标详情*/
  {
    path: '/materialProcurementBid/:id?',
    name: 'materialProcurementBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/calibration/component/materialProcurementBid.vue'
      )
  },
  /* 投标管理 --- 定标管理 物资采购 最低评标详情*/
  {
    path: '/materialEvaluation/:id?',
    name: 'materialEvaluation',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/calibration/component/materialEvaluation.vue'
      )
  },
  /* 投标管理 --- 定标管理 项目采购 查看明细*/
  {
    path: '/procurementProjectBid/:id?',
    name: 'procurementProjectBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/calibration/component/procurementProjectBid.vue'
      )
  },
  /* 投标管理 --- 定标管理 项目采购 评标确认*/
  {
    path: '/procurementProjectConfirm/:id?',
    name: 'procurementProjectConfirm',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/calibration/component/procurementProjectConfirm.vue'
      )
  },
  /* 定标管理 报价查看*/
  {
    path: 'evaluationReview',
    name: 'evaluationReview',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationReview/index.vue'
      )
  },
  {
    path: 'ReprocurementDetails',
    name: 'ReprocurementDetails',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationReview/component/ReprocurementDetails.vue'
      )
  },
  /* 投标管理 --- 物资采购 评标 */
  {
    path: '/ReprocurementBid/:ids?',
    name: 'ReprocurementBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationReview/component/ReprocurementBid.vue'
      )
  },
  /* 投标管理 --- 物资采购 最低评标 */
  {
    path: '/ReminProcurementBid/:ids?',
    name: 'ReminProcurementBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationReview/component/ReminProcurementBid.vue'
      )
  },
  /* 投标管理 --- 项目采购 查看明细 */
  {
    path: 'ReprojectProcureDetails',
    name: 'ReprojectProcureDetails',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationReview/component/ReprojectProcureDetails.vue'
      )
  },
  /* 投标管理 --- 项目采购 评标 */
  {
    path: '/ReprojectProcureBid/:id?',
    name: 'ReprojectProcureBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationReview/component/ReprojectProcureBid.vue'
      )
  },
  /* 投标管理 --- 物资采购 最低评标 */
  {
    path: '/ReminProjectProcureBid/:id?',
    name: 'ReminProjectProcureBid',
    component: () =>
      import(
        '@/views/Normal/ManagementBid/evaluationReview/component/ReminProjectProcureBid.vue'
      )
  },

  /* 中标管理 --- 中标通知  */
  {
    path: 'notificationWinningBid',
    name: 'notificationWinningBid',
    component: () =>
      import('@/views/Normal/winningBid/notificationWinningBid/index.vue')
  },
  /* 中标管理 --- 中标通知 --- 管理成交通知(列表按钮)  */
  {
    path: '/notificationWinningBidDetail/:id?',
    name: 'notificationWinningBidDetail',
    component: () =>
      import(
        '@/views/Normal/winningBid/notificationWinningBid/component/notificationWinningBidDetail.vue'
      )
  },
  /* 中标管理 --- 中标通知 --- 管理成交通知(列表按钮) --- 新增修改  */
  {
    path: 'notificationWinningBidAddDialog',
    name: 'notificationWinningBidAddDialog',
    component: () =>
      import(
        '@/views/Normal/winningBid/notificationWinningBid/component/notificationWinningBidAddDialog.vue'
      )
  },
  /* 中标管理 --- 中标通知 --- 项目管理成交通知(列表按钮)  */
  {
    path: '/projectNoticeDetails/:id?',
    name: 'projectNoticeDetails',
    component: () =>
      import(
        '@/views/Normal/winningBid/notificationWinningBid/component/projectNoticeDetails.vue'
      )
  },
  /* 中标管理 --- 中标通知 --- 项目管理成交通知(列表按钮) --- 新增修改  */
  {
    path: 'projectNoticeAdd',
    name: 'projectNoticeAdd',
    component: () =>
      import(
        '@/views/Normal/winningBid/notificationWinningBid/component/projectNoticeAdd.vue'
      )
  },
  /* 中标管理 --- 中标通知 --- 管理成交通知(列表按钮) --- 详情  */
  {
    path: 'notificationWinningBidInsideDetail',
    name: 'notificationWinningBidInsideDetail',
    component: () =>
      import(
        '@/views/Normal/winningBid/notificationWinningBid/component/notificationWinningBidInsideDetail.vue'
      )
  },
  /* 中标管理 --- 中标确认  */
  {
    path: 'confirmationWinningBid',
    name: 'confirmationWinningBid',
    component: () =>
      import('@/views/Normal/winningBid/confirmationWinningBid/index.vue')
  },
  /* 中标管理 --- 中标确认 --- 详情  */
  {
    path: 'confirmationWinningBidDetail',
    name: 'confirmationWinningBidDetail',
    component: () =>
      import(
        '@/views/Normal/winningBid/confirmationWinningBid/component/confirmationWinningBidDetail.vue'
      )
  },
  /* 中标管理 --- 中标确认 --- 查看成交通知(列表按钮)  */
  {
    path: 'confirmationWinningBidView',
    name: 'confirmationWinningBidView',
    component: () =>
      import(
        '@/views/Normal/winningBid/confirmationWinningBid/component/confirmationWinningBidView.vue'
      )
  },
  /* 中标管理 --- 中标公示  */
  {
    path: 'announcementWinningBid',
    name: 'announcementWinningBid',
    component: () =>
      import('@/views/Normal/winningBid/announcementWinningBid/index.vue')
  },
  /* 中标管理 --- 中标公示 --- 查看成交通知(列表按钮)  */
  {
    path: 'announcementWinningBidView',
    name: 'announcementWinningBidView',
    component: () =>
      import(
        '@/views/Normal/winningBid/announcementWinningBid/component/announcementWinningBidView.vue'
      )
  },
  /* 中标管理 --- 新增单一来源公示  */
  {
    path: 'transactionPublicity',
    name: 'transactionPublicity',
    component: () =>
      import(
        '@/views/Normal/winningBid/announcementWinningBid/component/transactionPublicity.vue'
      )
  },
  /* 中标管理 --- 中标违约  */
  {
    path: 'defaultWinningBid',
    name: 'defaultWinningBid',
    component: () =>
      import('@/views/Normal/winningBid/defaultWinningBid/index.vue')
  },
  /* 中标管理 --- 中标违约 --- 物资采购详情  */
  {
    path: 'defaultWinningBidGoodsDetail',
    name: 'defaultWinningBidGoodsDetail',
    component: () =>
      import(
        '@/views/Normal/winningBid/defaultWinningBid/component/defaultWinningBidGoodsDetail.vue'
      )
  },
  /* 中标管理 --- 中标违约 --- 项目采购详情  */
  {
    path: 'defaultWinningBidPorjectDetail',
    name: 'defaultWinningBidPorjectDetail',
    component: () =>
      import(
        '@/views/Normal/winningBid/defaultWinningBid/component/defaultWinningBidPorjectDetail.vue'
      )
  },
  /* 中标管理 --- 违约记录  */
  {
    path: 'recordDefault',
    name: 'recordDefault',
    component: () => import('@/views/Normal/winningBid/recordDefault/index.vue')
  },
  /* 中标管理 --- 违约记录 --- 物资采购详情  */
  {
    path: 'recordDefaultGoodsDetail',
    name: 'recordDefaultGoodsDetail',
    component: () =>
      import(
        '@/views/Normal/winningBid/recordDefault/component/recordDefaultGoodsDetail.vue'
      )
  },
  /* 中标管理 --- 违约记录 --- 项目采购详情  */
  {
    path: 'recordDefaultPorjectDetail',
    name: 'recordDefaultPorjectDetail',
    component: () =>
      import(
        '@/views/Normal/winningBid/recordDefault/component/recordDefaultPorjectDetail.vue'
      )
  },

  /* 合同管理 --- 合同编制  */
  {
    path: 'contractPreparation',
    name: 'contractPreparation',
    component: () =>
      import('@/views/Normal/contractManagement/contractPreparation/index.vue')
  },
  /* 合同管理 --- 合同编制 新增修改  */
  {
    path: 'contractPreparationAddDialog',
    name: 'contractPreparationAddDialog',
    component: () =>
      import(
        '@/views/Normal/contractManagement/contractPreparation/component/contractPreparationAddDialog.vue'
      )
  },
  /* 合同管理 --- 合同编制 详情  */
  {
    path: 'contractPreparationDetail',
    name: 'contractPreparationDetail',
    component: () =>
      import(
        '@/views/Normal/contractManagement/contractPreparation/component/contractPreparationDetail.vue'
      )
  },
  /* 合同管理 --- 合同签订  */
  {
    path: 'contracting',
    name: 'contracting',
    component: () =>
      import('@/views/Normal/contractManagement/contracting/index.vue')
  },
  /* 合同管理 --- 合同签订 新增修改  */
  {
    path: 'contractingAddDialog',
    name: 'contractingAddDialog',
    component: () =>
      import(
        '@/views/Normal/contractManagement/contracting/component/contractingAddDialog.vue'
      )
  },
  /* 合同管理 --- 合同签订 详情  */
  {
    path: 'contractingDetail',
    name: 'contractingDetail',
    component: () =>
      import(
        '@/views/Normal/contractManagement/contracting/component/contractingDetail.vue'
      )
  },
  /* 合同管理 --- 合同查询  */
  {
    path: 'inquiryContract',
    name: 'inquiryContract',
    component: () =>
      import('@/views/Normal/contractManagement/inquiryContract/index.vue')
  },
  /* 合同管理 --- 合同查询 新增修改  */
  {
    path: 'inquiryContractAddDialog',
    name: 'inquiryContractAddDialog',
    component: () =>
      import(
        '@/views/Normal/contractManagement/inquiryContract/component/inquiryContractAddDialog.vue'
      )
  },
  /* 合同管理 --- 合同查询 详情  */
  {
    path: 'inquiryContractDetail',
    name: 'inquiryContractDetail',
    component: () =>
      import(
        '@/views/Normal/contractManagement/inquiryContract/component/inquiryContractDetail.vue'
      )
  },
  /* 合同管理 --- 合同前不执行  */
  {
    path: 'notExecuted',
    name: 'notExecuted',
    component: () =>
      import('@/views/Normal/contractManagement/notExecuted/index.vue')
  },
  /* 合同管理 --- 合同前不执行 --- 物资采购详情  */
  {
    path: 'conSingleDetail',
    name: 'conSingleDetail',
    component: () =>
      import(
        '@/views/Normal/contractManagement/notExecuted/component/conSingleDetail.vue'
      )
  },
  /* 合同管理 --- 合同前不执行 --- 项目采购详情  */
  {
    path: 'conWholeDeaile',
    name: 'conWholeDeaile',
    component: () =>
      import(
        '@/views/Normal/contractManagement/notExecuted/component/conWholeDeaile.vue'
      )
  },
  /* 订单管理 --- 采购订单  */
  {
    path: 'purchaseOrder',
    name: 'purchaseOrder',
    component: () =>
      import('@/views/Normal/orderManagement/purchaseOrder/index.vue')
  },
  /* 订单管理 --- 采购订单 --- 详情  */
  {
    path: 'purchaseOrderDetail',
    name: 'purchaseOrderDetail',
    component: () =>
      import(
        '@/views/Normal/orderManagement/purchaseOrder/component/purchaseOrderDetail.vue'
      )
  },
  /* 订单管理 --- 采购订单 --- 新增修改  */
  {
    path: 'purchaseOrderAddDialog',
    name: 'purchaseOrderAddDialog',
    component: () =>
      import(
        '@/views/Normal/orderManagement/purchaseOrder/component/purchaseOrderAddDialog.vue'
      )
  },
  /* 订单管理 --- 订单确认  */
  {
    path: 'orderConfirmation',
    name: 'orderConfirmation',
    component: () =>
      import('@/views/Normal/orderManagement/orderConfirmation/index.vue')
  },
  /* 订单管理 --- 订单确认 --- 详情  */
  {
    path: 'orderConfirmationDetail',
    name: 'orderConfirmationDetail',
    component: () =>
      import(
        '@/views/Normal/orderManagement/orderConfirmation/component/orderConfirmationDetail.vue'
      )
  },
  /* 订单管理 --- 订单管理  */
  {
    path: 'orderMange',
    name: 'orderMange',
    component: () =>
      import('@/views/Normal/orderManagement/orderMange/index.vue')
  },
  /* 订单管理 --- 订单管理 --- 详情  */
  {
    path: 'orderMangeDetail',
    name: 'orderMangeDetail',
    component: () =>
      import(
        '@/views/Normal/orderManagement/orderMange/component/orderMangeDetail.vue'
      )
  },
  /* 订单管理 --- 订单管理 --- 新增修改  */
  {
    path: 'orderMangeAddDialog',
    name: 'orderMangeAddDialog',
    component: () =>
      import(
        '@/views/Normal/orderManagement/orderMange/component/orderMangeAddDialog.vue'
      )
  },
  /* 订单管理 --- 订单查询  */
  {
    path: 'orderQuery',
    name: 'orderQuery',
    component: () =>
      import('@/views/Normal/orderManagement/orderQuery/index.vue')
  },
  /* 订单管理 --- 订单查询 --- 详情  */
  {
    path: 'orderQueryDetail',
    name: 'orderQueryDetail',
    component: () =>
      import(
        '@/views/Normal/orderManagement/orderQuery/component/orderQueryDetail.vue'
      )
  },

  /* 销售制单 --- 销售发货  */
  {
    path: 'shipmentsSales',
    name: 'shipmentsSales',
    component: () =>
      import('@/views/Normal/salesOrder/shipmentsSales/index.vue')
  },
  /* 销售制单 --- 销售发货 新增修改 */
  {
    path: 'shipmentsAddDialog',
    name: 'shipmentsAddDialog',
    component: () =>
      import(
        '@/views/Normal/salesOrder/shipmentsSales/component/shipmentsAddDialog.vue'
      )
  },
  /* 销售制单 --- 销售发货 详情 */
  {
    path: 'shipmentsDetail',
    name: 'shipmentsDetail',
    component: () =>
      import(
        '@/views/Normal/salesOrder/shipmentsSales/component/shipmentsDetail.vue'
      )
  },
  /* 销售制单 --- 销售查询  */
  {
    path: 'inquiriesSales',
    name: 'inquiriesSales',
    component: () =>
      import('@/views/Normal/salesOrder/inquiriesSales/index.vue')
  },
  /* 销售制单 --- 销售查询 详情 */
  {
    path: 'inquiriesSalesDetail',
    name: 'inquiriesSalesDetail',
    component: () =>
      import(
        '@/views/Normal/salesOrder/inquiriesSales/component/inquiriesSalesDetail.vue'
      )
  },
  /* 销售制单 --- 售后处理  */
  {
    path: 'afterProcessing',
    name: 'afterProcessing',
    component: () =>
      import('@/views/Normal/salesOrder/afterProcessing/index.vue')
  },
  /* 销售制单 --- 售后处理 详情 */
  {
    path: 'afterProcessingDetail',
    name: 'afterProcessingDetail',
    component: () =>
      import(
        '@/views/Normal/salesOrder/afterProcessing/component/afterProcessingDetail.vue'
      )
  },
  /* 收货管理 --- 收货确认  */
  {
    path: 'confirmationReceipt',
    name: 'confirmationReceipt',
    component: () =>
      import('@/views/Normal/receiptManagement/confirmationReceipt/index.vue')
  },
  /* 收货管理 --- 收货新增编辑  */
  {
    path: 'confirmationReceiptAdd',
    name: 'confirmationReceiptAdd',
    component: () =>
      import('@/views/Normal/receiptManagement/confirmationReceipt/component/confirmationReceiptAdd.vue')
  },
  /* 收货管理 --- 收货确认 详情 */
  {
    path: 'confirmationReceiptDetail',
    name: 'confirmationReceiptDetail',
    component: () =>
      import(
        '@/views/Normal/receiptManagement/confirmationReceipt/component/confirmationReceiptDetail.vue'
      )
  },
  /* 收货管理 --- 收货查询  */
  {
    path: 'inquiryReceipt',
    name: 'inquiryReceipt',
    component: () =>
      import('@/views/Normal/receiptManagement/inquiryReceipt/index.vue')
  },
  /* 收货管理 --- 收货查询 详情 */
  {
    path: 'inquiryReceiptDetail',
    name: 'inquiryReceiptDetail',
    component: () =>
      import(
        '@/views/Normal/receiptManagement/inquiryReceipt/component/inquiryReceiptDetail.vue'
      )
  },
  /* 收货管理 --- 售后管理  */
  {
    path: 'afterSalesManagement',
    name: 'afterSalesManagement',
    component: () =>
      import('@/views/Normal/receiptManagement/afterSalesManagement/index.vue')
  },
  /* 收货管理 --- 收货管理 详情 */
  {
    path: 'afterSalesManagementDetail',
    name: 'afterSalesManagementDetail',
    component: () =>
      import(
        '@/views/Normal/receiptManagement/afterSalesManagement/component/afterSalesManagementDetail.vue'
      )
  },
  /* 对账管理 --- 对账单管理  */
  {
    path: 'statementManagement',
    name: 'statementManagement',
    component: () =>
      import(
        '@/views/Normal/reconciliationManagement/statementManagement/index.vue'
      )
  },
  /* 对账管理 --- 对账单管理  新增修改*/
  {
    path: 'statementManagementAddDialog',
    name: 'statementManagementAddDialog',
    component: () =>
      import(
        '@/views/Normal/reconciliationManagement/statementManagement/component/statementManagementAddDialog.vue'
      )
  },
  /* 对账管理 --- 对账单管理  详情*/
  {
    path: 'statementManagementDetail',
    name: 'statementManagementDetail',
    component: () =>
      import(
        '@/views/Normal/reconciliationManagement/statementManagement/component/statementManagementDetail.vue'
      )
  },
  /* 对账管理 --- 对账单确认  */
  {
    path: 'confirmationStatement',
    name: 'confirmationStatement',
    component: () =>
      import(
        '@/views/Normal/reconciliationManagement/confirmationStatement/index.vue'
      )
  },
  /* 对账管理 --- 对账单确认 详情 */
  {
    path: 'confirmationStatementDetail',
    name: 'confirmationStatementDetail',
    component: () =>
      import(
        '@/views/Normal/reconciliationManagement/confirmationStatement/component/confirmationStatementDetail.vue'
      )
  },
  /* 对账管理 --- 对账单确认  意见反馈*/
  {
    path: 'confirmationOpinion',
    name: 'confirmationOpinion',
    component: () =>
      import(
        '@/views/Normal/reconciliationManagement/confirmationStatement/component/confirmationOpinion.vue'
      )
  },
  /* 对账管理 --- 对账单查询  */
  {
    path: 'inquiryStatement',
    name: 'inquiryStatement',
    component: () =>
      import(
        '@/views/Normal/reconciliationManagement/inquiryStatement/index.vue'
      )
  },
  /* 对账管理 --- 对账单查询 详情 */
  {
    path: 'inquiryStatementRecording',
    name: 'inquiryStatementRecording',
    component: () =>
      import(
        '@/views/Normal/reconciliationManagement/inquiryStatement/component/inquiryStatementRecording.vue'
      )
  }
]
