import req from '@/request.js'
import utils from '@/utils.js'
// import sat from '@/api/satisfaction/satisfaction'
// import pilot from '@/api/pilotprojects'
const portal = window.context.portal
export const TableMixin = {
  data() {
    return {
      tableMaxHeight: 550,
      showMore: false,
      header: {
        Authorization: `Bearer ${this.$store.state.login.currentUser.token}`
      },

      deleteIds: '',
      tableData: [],
      loading: false,
      searchPanel: 0,
      pageResult: {
        page: 1,
        totol: 1,
        pageSize: 20
      }
    }
  },
  mounted() {
    this.calcTableHeight()
    // this.$root.$on('resize', () => {
    //     this.calcTableHeight(500)
    // })
  },
  created() {},
  methods: {
    //添加
    handleAdd() {
      this.$refs.formDialog.open()
    },
    handleEdit(row) {
      // this.$refs.formDialog.open(row, 'edit')
    },
    handleDetail(row) {
      // this.$refs.formDialog.open(row, 'detail')
    },
    //获取删除数据id集合
    handleSelectionChange(val) {
      let arr = val.map(item => item.id)
      this.deleteIds = arr.join(',')
    },
    // 获取字典值翻译
    getDictName(code, value) {
      return utils.getDictName(code, value)
    },
    calcTableHeight(delay) {
      // 动态计算表格的高度，自适应当前容器
      setTimeout(() => {
        if (!this.$refs.contentPanel) {
          return
        }
        // 容器高度 - 内边距
        let contentPanel = 0
        const contentPanelHeight =
          this.$refs.contentPanel.clientHeight ||
          this.$refs.contentPanel.$el.clientHeight
        // let contentPanelPaddingT = getComputedStyle(this.$refs.contentPanel.$el)
        //     .getPropertyValue('padding-top')
        //     .replace('px', '')
        // let contentPanelPaddingB = getComputedStyle(this.$refs.contentPanel.$el)
        //     .getPropertyValue('padding-bottom')
        //     .replace('px', '')
        // let contentPanelPadding =
        //     parseInt(contentPanelPaddingT, 10) +
        //     parseInt(contentPanelPaddingB, 10)
        contentPanel = contentPanelHeight
        this.searchPanel = contentPanel

        //按钮高度 + 下外边距
        // let btnPanelHeight = 10,
        //     btnPanel,
        //     btnPanelMarginB = 0
        // if (this.$refs.btnPanel.clientHeight) {
        //     btnPanelHeight = this.$refs.btnPanel.clientHeight
        //     btnPanel = this.$refs.btnPanel
        // } else if (
        //     this.$refs.btnPanel.$el &&
        //     this.$refs.btnPanel.$el.clientHeight
        // ) {
        //     btnPanel = this.$refs.btnPanel.$el
        //     btnPanelHeight = this.$refs.btnPanel.$el.clientHeight
        // }
        // if (btnPanel) {
        //     btnPanelMarginB = getComputedStyle(btnPanel)
        //         .getPropertyValue('margin-bottom')
        //         .replace('px', '')
        //     btnPanelHeight = btnPanelHeight + parseInt(btnPanelMarginB, 10)
        // }

        //分页高度 + 上外边距
        // let paginationPanelHeight = 0,
        //     paginationPanelMarginT = 0

        // if (
        //     this.$refs.paginationPanel.$el &&
        //     this.$refs.paginationPanel.$el.clientHeight
        // ) {
        //     paginationPanelHeight = this.$refs.paginationPanel.$el.clientHeight
        //     paginationPanelMarginT = getComputedStyle(
        //         this.$refs.paginationPanel.$el
        //     )
        //         .getPropertyValue('margin-top')
        //         .replace('px', '')
        // }

        // paginationPanelHeight =
        //     paginationPanelHeight + parseInt(paginationPanelMarginT, 10)

        // console.log(contentPanel, btnPanelHeight, paginationPanelHeight)

        // this.tableMaxHeight =
        //     contentPanel - btnPanelHeight - paginationPanelHeight
      }, delay || 0)
    },
    commonPageClick() {
      if (this.showMore) {
        this.showMore = false
      }
    },
    // 展开高级搜索
    advanced() {
      this.isAdvanced = !this.isAdvanced
      this.$nextTick(() => {
        this.calcTableHeight(500)
      })
    },
    clearSearchForm() {
      this.advanced()
      this.isAdvanced = false
      this.searchForm = {}
      if (this.slefClearMethods) {
        this.slefClearMethods()
      }
      this.handleSearch(1)
    },
    // 分页
    handleCurrentChange(page) {
      this.reqData.pageBean.page = page
      this.getTableData()
    },
    handleSizeChange(pageSize) {
      this.reqData.pageBean.pageSize = pageSize
      this.getTableData(1)
    },
    // 计算表格高度
    calcTableHeight(delay = 0) {
      // 动态计算表格的高度，自适应当前容器
      setTimeout(() => {
        if (!this.$refs.tabelRef) return
        const contentPanelHeight =
          this.$refs.tabelRef && this.$refs.tabelRef.clientHeight
        const paginationPanelHeight = this.$refs.paginationPanel ? 32 : 0
        this.tableMaxHeight = contentPanelHeight - paginationPanelHeight - 32
      }, delay || 0)
    }
  }
}
