/* 供应商管理接口管理 */
import req from '@/request.js'
const portal = window.context.portal

export default {
  // 供应商分类---分页
  queryClassification(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizSupplierType/v1/page`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商分类--根据id查询实体信息
  getByIdClassification(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizSupplierType/v1/selectOne`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商分类--保存
  saveClassification(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizSupplierType/v1/saveOrUpdateEntity`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商分类--删除
  delClassification(ids) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizSupplierType/v1/remove?${ids}`).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 供应商评价---分页
  queryManage(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/supplier/bizSupplierEvaluation/v1/pageAll`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商管理--根据id查询实体信息
  getByIdManage(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/supplier/bizSupplierEnterprise/v1/getById/${id}`).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商管理--保存
  saveManage(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/supplier/bizSupplierEnterprise/v1/saveOrUpdateEntity`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商管理--删除
  delManage(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/supplier/bizSupplierEnterprise/v1/?${ids}`).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  // 供应商黑名单---分页
  queryBlacklist(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizSupplierOrgBlacklist/v1/page`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商黑名单--根据id查询实体信息
  getByIdBlacklist(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizSupplierOrgBlacklist/v1/selectOne`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商黑名单--保存
  saveBlacklist(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizSupplierOrgBlacklist/v1/saveOrUpdateEntity`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商黑名单--删除
  delBlacklist(ids) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizSupplierOrgBlacklist/v1/remove?${ids}`).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商评价---分页
  queryEvaluationlist(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/supplier/bizSupplierEvaluation/v1/pageAll`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 企业评价--根据id查询实体信息
  getByIdEvaluationlist(id) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/supplier/bizSupplierEvaluation/v1/getById/${id}`).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 企业评价--保存
  saveEvaluationlist(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/supplier/bizSupplierEvaluation/v1/saveOrUpdateEntity`, data).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 供应商评价--删除
  delEvaluationlist(ids) {
    return new Promise((resolve, reject) => {
      req.remove(portal + `/supplier/bizSupplierEvaluation/v1/?${ids}`).then(
        res => {
          resolve(res)
        },
        error => {
          reject(error)
        }
      )
    })
  },
}
