import req from '@/request.js'

const yhxt = window.context.yhxt
const portal = window.context.portal
const uc = window.context.uc
export default {
  // 物料采购管理 采购申请 分页查询数据
  bizPurchasingApplicationPage(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/purchasingApplication/v1/curUserData`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料采购管理 采购申请 新增或修改
  bizPurchasingApplicationSaveOrUpdate(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/purchasingApplication/v1/saveOrUpdate`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料采购管理 采购申请 查询详情
  bizPurchasingApplicationSelectOne(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/purchasingApplication/v1/selectOne?id=` + data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //物料采购管理 采购申请 批量删除物料分类名称
  bizPurchasingApplicationRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/purchasingApplication/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料采购管理 采购立项 分页查询数据
  bizProjectApprovalPage(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/matApproval/v1/page`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料采购管理 采购立项 新增或修改
  bizProjectApprovalSaveOrUpdate(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/matApproval/v1/saveOrUpdate`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料采购管理 采购立项 查询详情
  bizProjectApprovalSelectOne(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/matApproval/v1/getDataById?id=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料采购管理 采购立项 批量删除物料分类名称
  bizProjectApprovalRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/matApproval/v1/removeByIds` , data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料采购管理 采购立项 修改发布状态
  bizProjectApprovalUpdateStatus(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          portal +
            `/matApproval/v1/modifyBidStatus?status=${data.status}&ids=${data.id}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  // 项目采购管理 项目基础信息 分页查询数据
  bizProjectInfoPage(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/projectInfo/v1/page`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //项目采购管理 项目基础信息 新增或修改
  bizProjectInfoSaveOrUpdate(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizProjectInfo/v1/saveOrUpdate`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //项目采购管理 项目基础信息 查询详情
  bizProjectInfoSelectOne(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizProjectInfo/v1/selectOne?id=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //项目采购管理 项目基础信息 批量删除物料分类名称
  bizProjectInfoRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/projectInfo/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 项目采购管理 采购立项 分页查询数据
  projectApprovalProDetailsPage(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/projectApproval/v1/page`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //项目采购管理 采购立项 新增或修改
  projectApprovalProDetailsSaveOrUpdate(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/projectApproval/v1/saveOrUpdate`, data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //项目采购管理 采购立项 查询详情
  projectApprovalProDetails(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/projectApproval/v1/getDataById?id=` + data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //项目采购管理 采购立项 批量删除物料分类名称
  projectApprovalProDetailsRemove(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/projectApproval/v1/removeByIds?ids=` + data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  }
}
