import req from '@/request.js'

const yhxt = window.context.yhxt
const portal = window.context.portal
const uc = window.context.uc
export default {
  //物料分类 分页查询结果
  bizMaterialCategoryQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizMaterialCategory/v1/query`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料分类 查询物料分类树结构
  bizMaterialCategorySelectTree(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizMaterialCategory/v1/selectTree`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料分类 修改物料分类状态
  bizMaterialCategoryUpdateStatus(data) {
    return new Promise((resolve, reject) => {
      req
        .post(
          portal + `/bizMaterialCategory/v1/updateStatus?status=${data.status}`,
          data.ids
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //物料分类 批量删除物料分类名称
  bizMaterialCategoryDeletCategory(data) {
    return new Promise((resolve, reject) => {
      req
        .post(portal + `/bizMaterialCategory/v1/deletCategory?ids=` + data)
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  },
  //物料分类 添加或修改物料分类名称
  bizMaterialCategorySaveCategory(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizMaterialCategory/v1/saveCategory`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料分类 导出数据到Excel
  bizMaterialCategoryExportExcelData(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizMaterialCategory/v1/exportExcelData`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //物料分类 查询详情
  bizMaterialCategoryId(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizMaterialCategory/v1/` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //公司物料库 分页查询结果
  bizMaterialQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/platMaterial/v1/page`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //公司物料库 导出数据到Excel
  bizMaterialExportExcelData(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizMaterial/v1/exportExcelData`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //公司物料库 批量删除物料分类名称
  bizMaterialRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizMaterial/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //公司物料库 添加或修改物料分类名称
  bizMaterialSave(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizMaterial/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //公司物料库 查询详情
  bizMaterialId(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizMaterial/v1/` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //资质类型 分页查询结果
  bizQualificationCategoryQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizQualificationCategory/v1/page`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //资质类型 添加或修改资质类型
  bizQualificationSaveCategory(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizQualificationCategory/v1/saveCategory`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //资质类型 删除资质类型
  bizQualificationSaveRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizQualificationCategory/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //资质类型 查询详情
  bizQualificationCategoryId(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizQualificationCategory/v1/` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //资质库 分页查询结果
  bizQualificationLabelQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizQualificationLabel/v1/page`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //资质库 添加或修改资质类型
  bizQualificationLabelSaveOrUpdate(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizQualificationLabel/v1/saveOrUpdate`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //资质库 批量删除
  bizQualificationLabelRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizQualificationLabel/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //资质库 查询详情
  bizQualificationLabelId(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizQualificationLabel/v1/` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //专家库 分页查询结果
  bizExpertDatabaseQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizExpertDatabase/v1/query`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //专家库 添加或修改专家分类
  bizExpertDatabaseSave(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizExpertDatabase/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //专家库 批量删除
  bizExpertDatabaseRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizExpertDatabase/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //专家库 查询详情
  bizExpertDatabaseId(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizExpertDatabase/v1/` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  //专家分类 分页查询结果
  bizExpertTypeQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizExpertType/v1/query`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //专家分类 添加或修改专家分类
  bizExpertTypeSave(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizExpertType/v1/save`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //专家分类 批量删除
  bizExpertTypeRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizExpertType/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //专家分类 查询详情
  bizExpertTypeId(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizExpertType/v1/` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  //评标项管理 分页查询结果
  bizEvaluationItemQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizEvaluationItem/v1/query`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //评标项管理 添加或修改专家分类
  bizEvaluationItemSaveItem(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizEvaluationItem/v1/saveItem`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //评标项管理 批量删除
  bizEvaluationItemRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizEvaluationItem/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //评标项管理 查询详情
  bizEvaluationItemId(data) {
    return new Promise((resolve, reject) => {
      req.get(portal + `/bizEvaluationItem/v1/` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //评标项管理 查询评标项目树结构
  bizEvaluationItemSelectTree(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizEvaluationItem/v1/selectTree`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  //综合评标法 分页查询结果
  bizEvaluationSystemQuery(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizEvaluationSystem/v1/page`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //综合评标法 使用单位
  getOrgPage(data) {
    return new Promise((resolve, reject) => {
      req.post(uc + `/api/org/v1/orgs/getOrgPage`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //综合评标法 组织单位
  getOrgAllMaster(data) {
    return new Promise((resolve, reject) => {
      req.post(uc + `/api/org/v1/orgs/getOrgAllMaster`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //综合评标法 添加或修改专家分类
  bizEvaluationSaveOrUpdate(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizEvaluationSystem/v1/saveOrUpdate`, data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //综合评标法 批量删除
  bizEvaluationSystemRemove(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizEvaluationSystem/v1/remove?ids=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //综合评标法 查询详情
  bizEvaluationSystemId(data) {
    return new Promise((resolve, reject) => {
      req.post(portal + `/bizEvaluationSystem/v1/selectOne?id=` + data).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },

  //获取公司信息
  getCompanyInfo_1(demId) {
    return new Promise((resolve, reject) => {
      req.get(uc + `/api/org/v1/orgs/getOrgsByparentId?parentId=${demId}`).then(
        resp => {
          resolve(resp.data)
        },
        error => {
          reject(error)
        }
      )
    })
  },
  //删除合同明细管理
  deleteContractDetailInfo(ids) {
    return new Promise((resolve, reject) => {
      req
        .remove(
          yhxt +
            `/bizProjectContractDetails/v1/updateContractDetails?ids=${ids}`
        )
        .then(
          resp => {
            resolve(resp.data)
          },
          error => {
            reject(error)
          }
        )
    })
  }
}
