import req from "@/request.js";
const portal = window.context.portal;
export default {
    // 发货管理开始
    // 销售分页
    queryEventsList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/arrival/v1/page`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 确认发货
    batchSent(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReceipt/v1/confrim_send?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    //发货提交
    batchSubmit(dialogForm, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizReceipt/v1/save` ,dialogForm).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 发货详情
    selectOne(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReceipt/v1/selectOne/?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 发货批量删除
    spliceDelete(deleteIds, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/arrival/v1/remove',deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 发货管理结束
    // 收货管理开始
    // 收货分页
    getGoods(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizReceipt/v1/page`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 确认收货
    batchReceipt(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReceipt/v1/confrim_receipt?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 收货详情
    selectTwo(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/arrival/v1/selectOne/?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 批量删除
    batchDelete(deleteIds, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReceipt/v1/remove',deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 收货管理结束
    // 获取订单列表
    // 分页
    querycCntractDetails(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizPurchaseOrder/v1/page`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 订单详情
    querycCntractDetailsOne(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizPurchaseOrder/v1/selectOne/?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    
    
     // 批量删除订单明细表
     batchDeleteDetails(deleteIds, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizPurchaseOrderDetail/v1/remove?ids=' + deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
     // 查询某个收货单的修改记录
     selectHandlelog(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReceiptHandle/v1/receipt/handlelog?receiptId=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })}
}