import req from "@/request.js";
const portal = window.context.portal;
export default {
    // 分页
    queryEventsList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizReconciliation/v1/page`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 获取发货列表
    // 分页
    querycCntractDetails(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizReceipt/v1/page`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 订单详情
    querycCntractDetailsOne(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReceipt/v1/selectOne/?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    //提交
    batchSubmit(dialogForm, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizReconciliation/v1/save` ,dialogForm).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
     //保存并发布
     batchSubmitStatus(dialogForm, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizReconciliation/v1/savestatus` ,dialogForm).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 批量删除
    batchDelete(deleteIds, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReconciliation/v1/remove' , deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
     // 账单发布
     batchSent(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReconciliation/v1/release?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },

     // 对账单确认
     batchconfrim(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReconciliation/v1/confrim?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
      // 对账单撤回
      batchReceipt(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReconciliation/v1/withdraw?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
    // 对账单拒绝
    batchRefuset(id,reason, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReconciliation/v1/refuse?id=' + id+'&reason='+reason).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
       // 详情
       selectOne(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizReconciliation/v1/selectOne?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
        
    },
    
     
}