import req from "@/request.js";
const portal = window.context.portal;
export default {
    // 分页
    queryEventsList(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizPurchaseOrder/v1/page`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
    // 获取合同详情物料列表
    // 分页
    querycCntractDetails(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizPurchaseOrder/v1/contractDetails`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
        })
    },
      // 获取合同列表
    // 分页
    querycCntract(data) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizContract/v1/page`, data).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                }
            )
            
        })
    },
    //提交
    batchSubmit(dialogForm, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal + `/bizPurchaseOrder/v1/save` ,dialogForm).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
        //提交并发布
        batchSubmitstatus(dialogForm, cb) {
            return new Promise((resolve, reject) => {
                req.post(portal + `/bizPurchaseOrder/v1/savestatus` ,dialogForm).then(
                    res => {
                        resolve(res)
                    },
                    error => {
                        reject(error)
                    });
            })
        },
    // 批量删除
    batchDelete(deleteIds, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizPurchaseOrder/v1/remove' ,deleteIds).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
     // 发布
     batchSent(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizPurchaseOrder/v1/release/?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },

     // 确认订单
     batchConfirmation(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizPurchaseOrder/v1/confirm/?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
       // 详情
       selectOne(id, cb) {
        return new Promise((resolve, reject) => {
            req.post(portal +'/bizPurchaseOrder/v1/selectOne/?id=' + id).then(
                res => {
                    resolve(res)
                },
                error => {
                    reject(error)
                });
        })
    },
}