package com.artfess.workflow.runtime.listener;

import com.artfess.base.exception.BaseException;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.event.DoTaskEvent;
import com.artfess.workflow.runtime.manager.TaskTransService;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

@Service
public class DoTaskEventListener implements ApplicationListener<DoTaskEvent>{
	@Resource
	TaskTransService taskTransService;

	@Override
	public void onApplicationEvent(DoTaskEvent arg0) {
		try {
			Map<String, Object> map = (Map<String, Object>) arg0.getSource();
			String taskId = map.get("taskId").toString();
			String actionName = map.get("actionName").toString();
			String notifyType = map.get("notifyType").toString();
			String opinion = map.get("opinion").toString();
            String addSignAction = "";
			if(BeanUtils.isNotEmpty(map.get("addSignAction"))){
                addSignAction = map.get("addSignAction").toString();
            }
			taskTransService.completeTask(taskId, actionName, notifyType, opinion,addSignAction);
		} catch (Exception e) {
			throw new BaseException("流程任务处理失败",e);
		}
	}
}
