package com.artfess.security.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 系统功能 --数据库备份管理-数据源配置表
 *
 * @company wh
 * @author wh
 * @since 2021-04-22
 */
@ApiModel(value="BackupDatasource对象", description="数据库备份管理-数据源配置表")
@TableName("uc_backup_datasource")
public class BackupDatasource extends BaseModel<BackupDatasource> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "服务器类型【linux、windows】")
    @TableField("SYSTEM_TYPE_")
    private String systemType;

    @ApiModelProperty(value = "服务器IP")
    @TableField("SYSTEM_IP_")
    private String systemIp;

    @ApiModelProperty(value = "登录账号")
    @TableField("SYSTEM_USER_")
    private String systemUser;

    @ApiModelProperty(value = "登录密码")
    @TableField("SYSTEM_PWD_")
    private String systemPwd;

    @ApiModelProperty(value = "数据类型【mysql、oracle】")
    @TableField("DB_TYPE_")
    private String dbType;

    @ApiModelProperty(value = "数据库驱动")
    @TableField("DB_DRIVER_")
    private String dbDriver;

    @ApiModelProperty(value = "数据库端口")
    @TableField("DB_PORT_")
    private String dbPort;

    @ApiModelProperty(value = "数据库名称")
    @TableField("DB_NAME_")
    private String dbName;

    @ApiModelProperty(value = "连接URL")
    @TableField("DB_URL_")
    private String dbUrl;

    @ApiModelProperty(value = "连接账号")
    @TableField("DB_USER_")
    private String dbUser;

    @ApiModelProperty(value = "连接密码")
    @TableField("DB_PWD_")
    private String dbPwd;

    @ApiModelProperty(value = "备份脚本")
    @TableField("BACKUP_COMMOND_")
    private String backupCommond;

    @ApiModelProperty(value = "还原脚本")
    @TableField("REDUCTION_COMMOND_")
    private String reductionCommond;

    @ApiModelProperty(value = "备份类型【手动本分、自动备份】")
    @TableField("BACKUP_TYPE_")
    private String backupType;

    @ApiModelProperty(value = "自动备份CRON")
    @TableField("CRON_")
    private String cron;

    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @TableField("CREATE_BY_")
    private String createBy;

    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @TableField("UPDATE_BY_")
    private String updateBy;

//    @TableField("TENANT_ID_")
//    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getSystemType() {
        return systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }
    public String getSystemIp() {
        return systemIp;
    }

    public void setSystemIp(String systemIp) {
        this.systemIp = systemIp;
    }
    public String getSystemUser() {
        return systemUser;
    }

    public void setSystemUser(String systemUser) {
        this.systemUser = systemUser;
    }
    public String getSystemPwd() {
        return systemPwd;
    }

    public void setSystemPwd(String systemPwd) {
        this.systemPwd = systemPwd;
    }
    public String getDbType() {
        return dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }
    public String getDbDriver() {
        return dbDriver;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }
    public String getDbPort() {
        return dbPort;
    }

    public void setDbPort(String dbPort) {
        this.dbPort = dbPort;
    }
    public String getDbName() {
        return dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }
    public String getDbUrl() {
        return dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }
    public String getDbUser() {
        return dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }
    public String getDbPwd() {
        return dbPwd;
    }

    public void setDbPwd(String dbPwd) {
        this.dbPwd = dbPwd;
    }
    public String getBackupCommond() {
        return backupCommond;
    }

    public void setBackupCommond(String backupCommond) {
        this.backupCommond = backupCommond;
    }
    public String getReductionCommond() {
        return reductionCommond;
    }

    public void setReductionCommond(String reductionCommond) {
        this.reductionCommond = reductionCommond;
    }
    public String getBackupType() {
        return backupType;
    }

    public void setBackupType(String backupType) {
        this.backupType = backupType;
    }
    public String getCron() {
        return cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
//    public String getTenantId() {
//        return tenantId;
//    }
//
//    public void setTenantId(String tenantId) {
//        this.tenantId = tenantId;
//    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BackupDatasource{" +
            "id=" + id +
            ", systemType=" + systemType +
            ", systemIp=" + systemIp +
            ", systemUser=" + systemUser +
            ", systemPwd=" + systemPwd +
            ", dbType=" + dbType +
            ", dbDriver=" + dbDriver +
            ", dbPort=" + dbPort +
            ", dbName=" + dbName +
            ", dbUrl=" + dbUrl +
            ", dbUser=" + dbUser +
            ", dbPwd=" + dbPwd +
            ", backupCommond=" + backupCommond +
            ", reductionCommond=" + reductionCommond +
            ", backupType=" + backupType +
            ", cron=" + cron +
            ", updateTime=" + updateTime +
            ", createBy=" + createBy +
            ", createTime=" + createTime +
            ", createOrgId=" + createOrgId +
            ", updateBy=" + updateBy +
            //", tenantId=" + tenantId +
        "}";
    }
}
