package com.artfess.bo.instance.impl;

import com.artfess.base.util.JsonUtil;
import com.artfess.bo.instance.DataTransform;
import com.artfess.bo.model.BoData;
import com.artfess.bo.util.BoUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Service;

import java.io.IOException;

@Service
public class JsonTransformImpl implements DataTransform {
    @Override
    public BoData parse(String data) throws IOException {
        JsonNode jsonNode = JsonUtil.toJsonNode(data);
        return BoUtil.transJSON(jsonNode);
    }

    @Override
    public String getByData(BoData boData, boolean needInitData) throws IOException {
        ObjectNode json = BoUtil.toJSON(boData, needInitData);
        return json.toString();
    }
}
