package com.artfess.bo.instance;

import com.artfess.bo.model.BoData;

import java.io.IOException;

/**
 * 数据转换接口
 *
 * @author heyifan
 * @company 阿特菲斯信息技术有限公司
 * @email heyf@jee-soft.cn
 * @date 2018年4月12日
 */
public interface DataTransform {

    /**
     * 将字符串转换成BoData对象。
     *
     * @param    data    字符串格式数据
     * @return bo数据
     */
    BoData parse(String data) throws IOException;

    /**
     * 根据boData获取字符串数据
     * <pre>
     * 字符串数据的格式可以是json或者 xml
     * </pre>
     *
     * @param boData   bo数据
     * @param needInit 是否需要初始化数据
     * @return 字符串格式数据
     */
    String getByData(BoData boData, boolean needInit) throws IOException;
}
