package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.portal.params.RedisInfo;
import com.artfess.portal.persistence.manager.RedisService;
import com.artfess.portal.util.jvm.ApplicationMonitorMessage;
import com.artfess.portal.util.jvm.ApplicationMonitorTask;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.filechooser.FileSystemView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/monitor/actuator/v1")
@Api(tags = "系统配置-redis监控、jvm监控")
@ApiGroup(group= {ApiGroupConsts.GROUP_SYSTEM})
public class ActuatorRedisController extends BaseController {

	@Autowired
	private RedisService redisService;

	@Autowired
	private ApplicationMonitorTask jvmTask;

	@Resource
	CacheManager cacheManager;
	private static final CacheSetting cacheSetting = CacheSetting.buildDefault("字典缓存");

	/**
	 * Redis详细信息
	 * @return
	 * @throws Exception
	 */
	@GetMapping("/redis/info")
	@ApiOperation("Redis详细信息")
	public List<RedisInfo> getRedisInfo() throws Exception {
		List<RedisInfo> infoList = this.redisService.getRedisInfo();
		return infoList;
	}

	@GetMapping("/redis/keysSize")
	@ApiOperation("Redis数据库个数")
	public Map<String, Object>  getKeysSize() throws Exception {
		Map<String, Object> retuslt=redisService.getKeysSize();
		return retuslt;
	}

	@GetMapping("/redis/memoryInfo")
	@ApiOperation("获取 redis 内存信息")
	public Map<String, Object> getMemoryInfo() throws Exception {
		return this.redisService.getMemoryInfo();
	}

	/**
	 * @功能：获取磁盘信息
	 * @param request
	 * @param response
	 * @return
	 */
	@GetMapping("/redis/queryDiskInfo")
	@ApiOperation("获取磁盘信息")
	public List<Map<String, Object>> queryDiskInfo(HttpServletRequest request, HttpServletResponse response) {
			// 当前文件系统类
			FileSystemView fsv = FileSystemView.getFileSystemView();
			// 列出所有windows 磁盘
			File[] fs = File.listRoots();
			//log.info("查询磁盘信息:" + fs.length + "个");
			List<Map<String, Object>> list = new ArrayList<>();

			for (int i = 0; i < fs.length; i++) {
				if (fs[i].getTotalSpace() == 0) {
					continue;
				}
				Map<String, Object> map = new HashMap<>();
				map.put("name", fsv.getSystemDisplayName(fs[i]));
				map.put("max", fs[i].getTotalSpace());
				map.put("rest", fs[i].getFreeSpace());
				map.put("restPPT", (fs[i].getTotalSpace() - fs[i].getFreeSpace()) * 100 / fs[i].getTotalSpace());
				list.add(map);
			}
			return list;

	}

	@GetMapping("/jvm/jvmMessage")
	@ApiOperation("获取 jvm 内存信息")
	public ApplicationMonitorMessage jvmMessage() throws Exception {
		return jvmTask.doRun();
	}

	@PostMapping("/redis/getAllCache")
	@ApiOperation(value = "查找所有的缓存信息/根据key查找redis", httpMethod = "POST", notes = "查找所有的缓存信息/根据key查找redis")
	public Map<String,Object> getAllCache(@ApiParam("缓存Key值") @RequestParam(required = false) String cacheKey ){
	return 	this.redisService.getAllCache(cacheKey);

	}

	@PostMapping("/redis/deleteCache")
	@ApiOperation(value = "根据key删除缓存", httpMethod = "POST", notes = "根据key删除缓存")
	public String deleteCache(@ApiParam("缓存Key值") @RequestParam(required = true) String... cacheKey ){
	return 	this.redisService.deleteCache(cacheKey);

	}
}
