package com.artfess.base.handler;

import com.artfess.base.context.BaseContext;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;


/**
 * 字段自动填充处理器
 *
 * @company 广州宏天软件股份有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年4月8日
 */
@Component
public class AutoFillMetaObjectHandler implements MetaObjectHandler{
	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Resource
	BaseContext baseContext;

	@Override
	public void insertFill(MetaObject metaObject) {
		logger.info("start insert fill ....");
		boolean hasCreateBy = metaObject.hasSetter("createBy");
		if(hasCreateBy){
			this.setFieldValByName("createBy", baseContext.getCurrentUserId(), metaObject);
		}

		boolean hasCreateOrgId = metaObject.hasSetter("createOrgId");
		if(hasCreateOrgId){
			this.setFieldValByName("createOrgId", baseContext.getCurrentOrgId(), metaObject);
		}

		boolean hasCreateTime = metaObject.hasSetter("createTime");
		if(hasCreateTime){
			this.setFieldValByName("createTime", getSetterTypeOfLocal(metaObject, "createTime"), metaObject);
		}

		boolean hasLastTime = metaObject.hasSetter("lastTime");
		if(hasLastTime){
			this.setFieldValByName("lastTime", getSetterTypeOfLocal(metaObject, "lastTime"), metaObject);
		}
	}

	@Override
	public void updateFill(MetaObject metaObject) {
		logger.info("start update fill ....");
		boolean hasUpdateBy = metaObject.hasSetter("updateBy");
		if(hasUpdateBy){
			this.setFieldValByName("updateBy", baseContext.getCurrentUserId(), metaObject);
		}

		boolean hasUpdateOrgId = metaObject.hasSetter("updateOrgId");
		if(hasUpdateOrgId){
			this.setFieldValByName("updateOrgId", baseContext.getCurrentOrgId(), metaObject);
		}

		boolean hasUpdateTime = metaObject.hasSetter("updateTime");
		if(hasUpdateTime){
			this.setFieldValByName("updateTime",getSetterTypeOfLocal(metaObject, "updateTime"), metaObject);
		}

		boolean hasLastTime = metaObject.hasSetter("lastTime");
		if(hasLastTime){
			this.setFieldValByName("lastTime", getSetterTypeOfLocal(metaObject, "lastTime"), metaObject);
		}
	}

	/**
	 *  通过属性元信息获取指定属性的当前值
	 *  <p>主要解决不同的日期类型的字段当前值</p>
	 * @param metaObject
	 * @param propertyName
	 * @return
	 */
	private Object getSetterTypeOfLocal(MetaObject metaObject, String propertyName){
		Class<?> targetType = metaObject.getSetterType(propertyName);
		Object obj = null;
		if(LocalDateTime.class.equals(targetType)) {
			obj = LocalDateTime.now();
		}
		else if(LocalDate.class.equals(targetType)) {
			obj = LocalDate.now();
		}
		else if(Date.class.equals(targetType)) {
			obj = new Date();
		}
		return obj;
	}
}
