package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 组卷方式
 */
@Getter
public enum PaperWayTypeEnum {
    /**
     * 单选
     */
    sjzj("1", "随机组卷"),

    pzcj("2", "配置出卷"),

    sjcj("3", "随机出卷"),

    ;

    PaperWayTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        PaperWayTypeEnum[] values = values();
        for (PaperWayTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
