package com.artfess.examine.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 考试统计vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-17
 */
@Data
public class PaperStatisticalVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "总分数")
    private String totalScore;

    @ApiModelProperty(value = "应考试人数")
    private Integer totalNumber;

    @ApiModelProperty(value = "试卷名称")
    private String paperName;

    @ApiModelProperty(value = "平均分")
    private String avgScore;

    @ApiModelProperty(value = "实际考试人数")
    private Integer actualCount;

    @ApiModelProperty(value = "缺考人数")
    private Integer lackCount;

    @ApiModelProperty(value = "及格人数")
    private BigDecimal passCount;

    @ApiModelProperty(value = "及格率")
    private String passPercentage;

    @ApiModelProperty(value = "试卷状态【字典】（0：未发布，1：考试中，2：已结束）")
    private String paperStatus;

    @ApiModelProperty(value = "课目名称")
    private String subjectName;

    @ApiModelProperty(value = "考试开始时间")
    private LocalDateTime planStartTime;

    @ApiModelProperty(value = "考试结束时间")
    private LocalDateTime planEndTime;

    @ApiModelProperty(value = "考核类型【字典】（1普通考试、2年度考核），页面默认普通考试")
    private String paperType;
}
