package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.util.List;

/**
 * 年度考核课目
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-11-25
 */
@Data
@ApiModel(value="ExamYearAssessmentSub对象", description="年度考核课目")
public class ExamYearAssessmentSub extends AutoFillModel<ExamYearAssessmentSub> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请选择考核年份",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private String year;

    @NotBlank(message = "请选择岗位",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核岗位")
    @TableField("position_id_")
    private String positionId;

    @ApiModelProperty(value = "考核科目")
    @TableField("subject_ids_")
    private String subjectIds;

    @ApiModelProperty(value = "课目名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "考核状态【字典】（0:未开始1:开始考核）")
    @TableField("status_")
    private String status = "0";


    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;


    @NotEmpty(message = "请选择要考核的科目",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "选择的课目列表")
    @TableField(exist = false)
    private List<ExamSubjectInfo> subjectInfoList;

}
