package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;


/**
 * 考生考试记录（人员考试成绩）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamUserRecord对象", description="考生考试记录（人员考试成绩）")
public class ExamUserRecord extends AutoFillModel<ExamUserRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "试卷基础信息ID")
    @TableField("paper_id_")
    private String paperId;

    @ApiModelProperty(value = "考生ID")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(name = "account", notes = "账号")
    @TableField("account_")
    protected String account;

    @ApiModelProperty(value = "岗位id")
    @TableField("position_id_")
    private String positionId;

    @ApiModelProperty(value = "考生姓名")
    @TableField("user_name_")
    private String userName;

    @ApiModelProperty(value = "考试IP地址")
    @TableField("ip_")
    private String ip;

    @ApiModelProperty(value = "页面切换次数")
    @TableField("switch_count_")
    private Integer switchCount;

    @ApiModelProperty(value = "开考时间")
    @TableField("start_time_")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "交卷时间")
    @TableField("end_time_")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "所用时长（默认单位：分钟）")
    @TableField("answer_time_")
    private String answerTime;

    @ApiModelProperty(value = "得分")
    @TableField("sys_score_")
    private BigDecimal sysScore;

    @ApiModelProperty(value = "评分等级")
    @TableField("level_")
    private Integer level;

    @ApiModelProperty(value = "评卷人员ID")
    @TableField("mark_user_")
    private String markUser;

    @ApiModelProperty(value = "人工评卷时间")
    @TableField("mark_time_")
    private LocalDateTime markTime;

    @ApiModelProperty(value = "补考申请时间")
    @TableField("apply_time_")
    private LocalDateTime applyTime;

    @ApiModelProperty(value = "考试状态【字典】(0：未开考，1：待答卷， 2：考试中，3：已交卷，4：作弊，5：完成评卷,6:补考申请中，7：补考申请失败,8:补考申请成功)")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "线下考核详情（例如：5公里时长、引体向上个数等等）")
    @TableField("record_")
    private String record;

    @ApiModelProperty(value = "试卷名称")
    @TableField(exist = false)
    private String paperName;

    @ApiModelProperty(value = "课目名称")
    @TableField(exist = false)
    private String subjectName;

    @ApiModelProperty(value = "考试开始时间")
    @TableField(exist = false)
    private LocalDateTime planStartTime;

    @ApiModelProperty(value = "考试结束时间")
    @TableField(exist = false)
    private LocalDateTime planEndTime;

    @ApiModelProperty(value = "考试场地")
    @TableField(exist = false)
    private String roomName;

    @ApiModelProperty(value = "总分")
    @TableField(exist = false)
    private BigDecimal totalScore;

    @ApiModelProperty(value = "考试时长（分钟）")
    @TableField(exist = false)
    private BigDecimal timeLength;

    @ApiModelProperty(value = "总题目数")
    @TableField(exist = false)
    private Integer totalNumber;

    @ApiModelProperty(value = "试卷状态【字典】（0：未发布，1：考试中，2：已结束）")
    @TableField(exist = false)
    private String paperStatus;

    @ApiModelProperty(value = "考核类型【字典】（1普通考试、2年度考核），页面默认普通考试")
    @TableField(exist = false)
    private String paperType;

    @ApiModelProperty(value = "年度上报（0：未上报、1：已上报）")
    @TableField(exist = false)
    private String reportStatus;

}
