package com.artfess.examine.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 模拟考试详情
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Data
@ApiModel(value="ExamImitateRecordDetail对象", description="模拟考试详情")
public class ExamImitateRecordDetail extends AutoFillModel<ExamImitateRecordDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "记录ID")
    @TableField("record_id_")
    private String recordId;

    @ApiModelProperty(value = "试题ID")
    @TableField("question_id_")
    private String questionId;

    @ApiModelProperty(value = "试题题型【字典】（1：单选，2：多选，3：判断，4：填空，5：简答，6：操作）")
    @TableField("question_type_")
    private String questionType;

    @ApiModelProperty(value = "正确答案")
    @TableField("right_key_")
    private String rightKey;

    @ApiModelProperty(value = "答题结果")
    @TableField("result_")
    private String result;

    @ApiModelProperty(value = "是否正确【字典】（0：否，1：是）")
    @TableField("is_right_")
    private String isRight;

    @ApiModelProperty(value = "题目分数")
    @TableField("score_")
    private BigDecimal score;

    @ApiModelProperty(value = "实际得分")
    @TableField("actual_score_")
    private BigDecimal actualScore;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;
}
