package com.artfess.examine.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.examine.model.ExamPaperBase;
import com.artfess.examine.model.ExamQuestionsInfo;

import java.util.List;

/**
 * 试卷基础信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
public interface ExamPaperBaseManager extends BaseManager<ExamPaperBase> {

    String createInfo(ExamPaperBase t);

    String updateInfo(ExamPaperBase t);

    ExamPaperBase findById(String id);

    ExamPaperBase viewPaper(String id);

    List<ExamQuestionsInfo> processQuestionList(ExamPaperBase examPaperBase);

    void startPaper(String id);

    void addUser(ExamPaperBase t);

    PageList<ExamPaperBase> findByPage(QueryFilter<ExamPaperBase> queryFilter);

    Long getEndStatus(String subjectId);
}
