package com.artfess.examine.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.examine.manager.ExamNoticeManager;
import com.artfess.examine.model.ExamNotice;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

/**
 * 通知公告 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-19
 */
@Slf4j
@RestController
@Api(tags = "通知公告")
@RequestMapping("/exam/notice/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ExamNoticeController extends BaseController<ExamNoticeManager, ExamNotice> {

    @PostMapping("/modifyTopStatus")
    @ApiOperation("公告置顶")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.UPDATE, description = "公告置顶")
    public CommonResult<String> modifyTopStatus(@ApiParam(name = "model", value = "公告置顶") @RequestBody ExamNotice entity) {
        log.info("公告置顶请求参数:{}", JSON.toJSONString(entity));
        boolean b = baseService.modifyTopStatus(entity);
        log.info("公告置顶响应结果:{}", b);
        if (!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("/modifyStatus")
    @ApiOperation("修改公告状态")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.UPDATE, description = "修改公告状态")
    public CommonResult<String> modifyEnabled(@ApiParam(name = "model", value = "公告") @RequestBody ExamNotice entity) {
        log.info("修改公告状态请求参数:{}", JSON.toJSONString(entity));
        boolean b = baseService.modifyStatus(entity);
        log.info("修改公告状态响应结果:{}", b);
        if (!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping(value="/findByPage", produces={"application/json; charset=utf-8" })
    @ApiOperation("公告查询")
    public PageList<ExamNotice> findByPage(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<ExamNotice> queryFilter) {
        queryFilter.addFilter("endTime", LocalDateTime.now(), QueryOP.GREAT_EQUAL, FieldRelation.AND);
        FieldSort sort = new FieldSort();
        sort.setProperty("topStatus");
        sort.setDirection(Direction.DESC);
        queryFilter.getSorter().add(sort);
        return baseService.query(queryFilter);
    }

}
