package com.artfess.data.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;


/**
 * 训练器材使用明细
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Data
@ApiModel(value="BizTrainEquipmentDetail对象", description="训练器材使用明细")
public class BizTrainEquipmentDetail extends AutoFillModel<BizTrainEquipmentDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择器材", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "器材id")
    @TableField("equipment_id_")
    private String equipmentId;

    @ApiModelProperty(value = "数据状态【字典】（0：借用、1：归还）")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "器材数量")
    @TableField("num_")
    private BigDecimal num;

    @ApiModelProperty(value = "用户id")
    @TableField("user_id_")
    private String userId;

    @ApiModelProperty(value = "姓名")
    @TableField("user_name_")
    private String userName;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

}
