package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizUserTrainPlanDao;
import com.artfess.data.manager.BizExamPlanManager;
import com.artfess.data.manager.BizUserTrainPlanManager;
import com.artfess.data.model.BizExamPlan;
import com.artfess.data.model.BizUserTrainPlan;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.vo.OrgVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 考生训练计划 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-11-14
 */
@Service
public class BizUserTrainPlanManagerImpl extends BaseManagerImpl<BizUserTrainPlanDao, BizUserTrainPlan> implements BizUserTrainPlanManager {

    @Autowired
    private BizExamPlanManager examPlanManager;

    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;


    @Override
    public void importList(List<BizUserTrainPlan> list, String planId) {
        Assert.hasText(planId, "请选择要考勤的训练计划");
        BizExamPlan bizExamPlan = examPlanManager.get(planId);
        Assert.notNull(bizExamPlan, "训练计划不存在");

        QueryWrapper<BizUserTrainPlan> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.eq("plan_id_", planId);
        List<BizUserTrainPlan> userTrainPlans = this.list(queryWrapper);
        List<BizUserTrainPlan> updateUsers = Lists.newArrayList();

        Map<String, BizUserTrainPlan> detailMap = userTrainPlans.stream().collect(Collectors.toMap(item -> item.getUserName(), item -> item));

        List<OrgVo> orgVos = orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        AtomicReference<Long> num = new AtomicReference<>(0L);
        list.forEach(baseData -> {
            Assert.hasText(baseData.getUserName(), "请填写考生信息");
            Assert.notNull(baseData.getHour(), "请填写训练时长");
            if (!CollectionUtils.isEmpty(orgMap) && null != orgMap.get(baseData.getOrgName())) {
                baseData.setOrgId(orgMap.get(baseData.getOrgName()).getId());
            }

            if(null != detailMap && null != detailMap.get(baseData.getUserName())){
                BizUserTrainPlan userCheck = detailMap.get(baseData.getUserName());

                if(!"1".equals(userCheck.getStatus())){
                    num.getAndSet(num.get() + 1);
                }
                if(baseData.getHour().doubleValue() >= bizExamPlan.getHour().doubleValue()) {
                    userCheck.setStatus("2");
                }else{
                    userCheck.setStatus("1");
                }
                userCheck.setOrgId(baseData.getOrgId());
                userCheck.setHour(baseData.getHour());
                userCheck.setScore(baseData.getScore());

                updateUsers.add(userCheck);
            }else{
                num.getAndSet(num.get() + 1);
                baseData.setStatus("1");
                updateUsers.add(baseData);
            }
        });
        if(!CollectionUtils.isEmpty(updateUsers)) {
            if(null == bizExamPlan.getRealityNum()) {
                bizExamPlan.setRealityNum(0L);
            }
            bizExamPlan.setRealityNum(bizExamPlan.getRealityNum() + num.get());
            examPlanManager.updateById(bizExamPlan);
            this.saveOrUpdateBatch(updateUsers);
        }
    }
}
