package com.artfess.data.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.data.model.BizMonthPlanFile;
import com.artfess.data.dao.BizMonthPlanFileDao;
import com.artfess.data.manager.BizMonthPlanFileManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDate;

/**
 * 月训练计划文件表 服务实现类
 *
 * @author 超级管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2025-03-03
 */
@Service
public class BizMonthPlanFileManagerImpl extends BaseManagerImpl<BizMonthPlanFileDao, BizMonthPlanFile> implements BizMonthPlanFileManager {

    @Resource
    private BaseContext baseContext;


    @Override
    public boolean saveInfo(BizMonthPlanFile bizMonthPlanFile) {
        bizMonthPlanFile.setUploadingDate(LocalDate.now());
        bizMonthPlanFile.setUploadingUserId(baseContext.getCurrentUserId());
        bizMonthPlanFile.setUploadingUserName(baseContext.getCurrentUserName());
        return this.save(bizMonthPlanFile);
    }

    @Override
    public boolean updateInfo(BizMonthPlanFile bizMonthPlanFile) {
        bizMonthPlanFile.setUploadingDate(LocalDate.now());
        bizMonthPlanFile.setUploadingUserId(baseContext.getCurrentUserId());
        bizMonthPlanFile.setUploadingUserName(baseContext.getCurrentUserName());
        return this.updateById(bizMonthPlanFile);
    }
}
