package com.artfess.examine.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.examine.vo.PositionVo;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 训练考试科目
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-26
 */
@Data
@ApiModel(value="ExamSubjectInfo对象", description="训练考试科目")
public class ExamSubjectInfo extends AutoFillModel<ExamSubjectInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "科目编码（唯一值）")
    @TableField("code_")
    private String code;

    @Excel(name = "课目名称", column = "A")
    @NotBlank(message = "请输入课目名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "课目名称")
    @TableField("name_")
    private String name;

    @Excel(name = "训练类别", column = "B")
    @ApiModelProperty(value = "训练类别【字典】（1：基础共同训练，2：专业共同训练，3：岗前训练，4：岗位训练）")
    @TableField("train_type_")
    private String trainType;

    @Excel(name = "课目层级", column = "C")
    @ApiModelProperty(value = "课目层级【字典】（1：初级，2：中级，3：高级）")
    @TableField("train_level_")
    private String trainLevel;

    @Excel(name = "人员类别", column = "D")
    @ApiModelProperty(value = "人员类别id")
    @TableField("user_type_id_")
    private String userTypeId;

    @ApiModelProperty(value = "专业id")
    @TableField("major_id_")
    private String majorId;

    @Excel(name = "专业", column = "E")
    @ApiModelProperty(value = "专业")
    @TableField("major_name_")
    private String majorName;

    @Excel(name = "所属岗位", column = "F")
    @ApiModelProperty(value = "所属岗位")
    @TableField(exist = false)
    private String positonNames;

    @Excel(name = "所属组织", column = "G")
    @ApiModelProperty(value = "所属组织")
    @TableField(exist = false)
    private String orgName;
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "岗位信息")
    @TableField(exist = false)
    private List<PositionVo> PositonVos;

    @ApiModelProperty(value = "年份")
    @TableField(exist = false)
    private String year;

    @ApiModelProperty(value = "科目id")
    @TableField(exist = false)
    private String subjectId;

    /*** ====== 新增字段 -================== */
    @ApiModelProperty(value = "训练内容")
    @TableField("content_")
    private String content;

    @ApiModelProperty(value = "训练条件")
    @TableField("condition_")
    private String condition;

    @ApiModelProperty(value = "考核标准")
    @TableField("standard_")
    private String standard;

    @ApiModelProperty(value = "教练员ID")
    @TableField("coach_id_")
    private String coachId;

    @ApiModelProperty(value = "教练员")
    @TableField("coach_name_")
    private String coachName;

}
