package com.artfess.examine.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 考试任务表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-10-26
 */
@Data
@ApiModel(value="ExamPaperTask对象", description="考试任务表")
@FieldRepeat(fields = {"name"},message = "任务名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class ExamPaperTask extends BaseModel<ExamPaperTask> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写任务名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "任务名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "考试时长（分钟）")
    @TableField("time_length_")
    private BigDecimal timeLength;

    @ApiModelProperty(value = "及格率(%)")
    @TableField("pass_score_")
    private BigDecimal passScore;

    @ApiModelProperty(value = "参与人数")
    @TableField("total_person_")
    private Integer totalPerson;

    @ApiModelProperty(value = "试卷id")
    @TableField("paper_id_")
    private String paperId;

    @ApiModelProperty(value = "考试开始时间")
    @TableField("plan_start_time_")
    private LocalDateTime planStartTime;

    @ApiModelProperty(value = "考试结束时间")
    @TableField("plan_end_time_")
    private LocalDateTime planEndTime;

    @ApiModelProperty(value = "考试方式【字典】（1：线上，2：线下）")
    @TableField("train_model_")
    private Integer trainModel;

    @ApiModelProperty(value = "考试场地")
    @TableField("room_id_")
    private String roomId;

    @ApiModelProperty(value = "监考人员")
    @TableField("jk_person_id_")
    private String jkPersonId;

    @ApiModelProperty(value = "阅卷人员")
    @TableField("yj_person_id_")
    private String yjPersonId;

    @ApiModelProperty(value = "试卷状态【字典】（0：未发布，1：考试中，2：已结束，3：补考中）")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "页面切换次数(达到配置数量自动交卷)")
    @TableField("switch_count_")
    private Integer switchCount;
}
