package com.artfess.examine.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.data.vo.UserExamVo;
import com.artfess.examine.model.ExamUserEvaluationDetail;

import javax.servlet.http.HttpServletResponse;

/**
 * 年度考核成绩表 服务类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-12-07
 */
public interface ExamUserEvaluationDetailManager extends BaseManager<ExamUserEvaluationDetail> {

    PageList<ExamUserEvaluationDetail> findByPage(QueryFilter<ExamUserEvaluationDetail> queryFilter);

    void personArchivesExport(QueryFilter<ExamUserEvaluationDetail> queryFilter, HttpServletResponse response);

    PageList<UserExamVo> userStudyAnalyse(QueryFilter<ExamUserEvaluationDetail> queryFilter);

    String getSubjectNames(String positionId, String year, String userId);
}
