package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 教学资源数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizTeachingResourceData对象", description="教学资源数据")
public class BizTeachingResourceData extends AutoFillModel<BizTeachingResourceData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "备注", column = "A")
    @ApiModelProperty(value = "资源名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "知识分类")
    @TableField("knowledge_type_id_")
    private String knowledgeTypeId;

    @Excel(name = "内容类型", column = "B")
    @ApiModelProperty(value = "内容类型")
    @TableField("content_type_")
    private String contentType;

    @ApiModelProperty(value = "视频文件")
    @TableField("introduction_")
    private String introduction;

    @ApiModelProperty(value = "教学文件")
    @TableField("teaching_file_")
    private String teachingFile;

    @Excel(name = "发布单位", column = "E")
    @ApiModelProperty(value = "发布单位")
    @TableField("push_org_")
    private String pushOrg;

    @Excel(name = "发布人", column = "D")
    @ApiModelProperty(value = "发布人")
    @TableField("push_user_")
    private String pushUser;

    @Excel(name = "发布时间", column = "F")
    @ApiModelProperty(value = "发布时间")
    @TableField("push_time_")
    private LocalDate pushTime;

    @Excel(name = "审核人", column = "G")
    @ApiModelProperty(value = "审核人")
    @TableField("audit_user_")
    private String auditUser;

    @Excel(name = "审核结果", column = "I")
    @ApiModelProperty(value = "审核结果")
    @TableField("audit_result_")
    private String auditResult;

    @Excel(name = "审核意见", column = "J")
    @ApiModelProperty(value = "审核意见")
    @TableField("audit_audit_")
    private String auditAudit;

    @Excel(name = "审核时间", column = "H")
    @ApiModelProperty(value = "审核时间")
    @TableField("audit_time_")
    private LocalDate auditTime;

    @Excel(name = "简介", column = "C")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;
}
