package com.artfess.data.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 任教课目准备数据
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2024-09-02
 */
@Data
@ApiModel(value="BizTeachData对象", description="任教课目准备数据")
public class BizTeachData extends AutoFillModel<BizTeachData> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @Excel(name = "任教课目", column = "A")
    @ApiModelProperty(value = "任教课目")
    @TableField("subject_name_")
    private String subjectName;

    @Excel(name = "示讲视角情况", column = "B")
    @ApiModelProperty(value = "示讲视角情况")
    @TableField("show_view_")
    private String showView;

    @ApiModelProperty(value = "内容类型")
    @TableField("teach_type_")
    private String teachType;

    @ApiModelProperty(value = "教学资源名称")
    @TableField("resources_name_")
    private String resourcesName;

    @Excel(name = "审核人", column = "C")
    @ApiModelProperty(value = "审核人")
    @TableField("approve_name_")
    private String approveName;

    @Excel(name = "审核状态", column = "D")
    @ApiModelProperty(value = "审核状态")
    @TableField("approve_status_")
    private String approveStatus;

    @Excel(name = "备注", column = "E")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序（按照类型排序）")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "数据时间戳")
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=true)
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "任课关联资源信息")
    @TableField(exist = false)
    private List<BizSubjectResources> subjectResourcesList;

}
