/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.data.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.data.dao.BizTrainQuestionDataDao;
import com.artfess.data.manager.BizTrainQuestionDataManager;
import com.artfess.data.model.BizTrainQuestionData;
import com.artfess.examine.dao.ExamOrgEvaluationDao;
import com.artfess.examine.manager.ExamSubjectInfoManager;
import com.artfess.examine.model.ExamSubjectInfo;
import com.artfess.examine.vo.OrgVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BizTrainQuestionDataManagerImpl
extends BaseManagerImpl<BizTrainQuestionDataDao, BizTrainQuestionData>
implements BizTrainQuestionDataManager {
    @Resource
    private ExamOrgEvaluationDao orgEvaluationDao;
    @Autowired
    private ExamSubjectInfoManager subjectInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveList(List<BizTrainQuestionData> list) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List subjectInfos = this.subjectInfoManager.list((Wrapper)queryWrapper);
        Map<String, ExamSubjectInfo> subjectInfoMap = subjectInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        List<OrgVo> orgVos = this.orgEvaluationDao.orgList();
        Map<String, OrgVo> orgMap = orgVos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        list.forEach(baseData -> {
            Assert.hasText((String)baseData.getOrgName(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5355\u4f4d");
            Assert.hasText((String)baseData.getSubjectName(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u8bfe\u76ee");
            Assert.hasText((String)baseData.getYear(), (String)"\u8bf7\u586b\u5199\u8bad\u7ec3\u5e74\u5ea6");
            if (CollectionUtils.isEmpty((Map)subjectInfoMap)) {
                return;
            }
            if (!CollectionUtils.isEmpty((Map)subjectInfoMap) && null != subjectInfoMap.get(baseData.getSubjectName())) {
                baseData.setSubjectId(((ExamSubjectInfo)((Object)((Object)subjectInfoMap.get(baseData.getSubjectName())))).getId());
            }
            if (!CollectionUtils.isEmpty((Map)orgMap) && null != orgMap.get(baseData.getOrgName())) {
                baseData.setOrgId(((OrgVo)((Object)((Object)orgMap.get(baseData.getOrgName())))).getId());
            }
        });
        this.saveBatch(list);
    }
}

